/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.block.util.state.enums;

import java.util.function.BinaryOperator;
import net.minecraft.util.StringRepresentable;

public enum LogicatorMode implements StringRepresentable
{
    AND("and", Boolean::logicalAnd),
    OR("or", Boolean::logicalOr),
    XNOR("xnor", (b1, b2) -> b1 == b2),
    XOR("xor", Boolean::logicalXor);

    final String name;
    final BinaryOperator<Boolean> operator;

    private LogicatorMode(String name, BinaryOperator<Boolean> operator) {
        this.name = name;
        this.operator = operator;
    }

    public String m_7912_() {
        return this.name;
    }

    public boolean operate(boolean b1, boolean b2) {
        return (Boolean)this.operator.apply(b1, b2);
    }

    public LogicatorMode flipOperationType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OR -> AND;
            case AND -> OR;
            case XOR -> XNOR;
            case XNOR -> XOR;
        };
    }

    public LogicatorMode flipExclusivity() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OR -> XOR;
            case AND -> XNOR;
            case XOR -> OR;
            case XNOR -> AND;
        };
    }

    public LogicatorMode withExclusivity(boolean exclusivity) {
        return this.isExclusive() == exclusivity ? this : this.flipExclusivity();
    }

    public boolean isExclusive() {
        return this == XOR || this == XNOR;
    }

    public boolean isOr() {
        return this == OR || this == XOR;
    }

    public static LogicatorMode getMode(boolean isExclusive, boolean isOr) {
        return !isExclusive ? (!isOr ? AND : OR) : (!isOr ? XNOR : XOR);
    }
}

