/*
 * Decompiled with CFR 0.152.
 */
package waves.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLPaths;
import waves.util.JsonHelpers;

public class WaveDataManager {
    public static final WaveDataManager WAVE_DATA = new WaveDataManager();
    public List<WaveData> waves = new ArrayList<WaveData>();
    public static final ConcurrentMap<String, Integer> SEA_LEVEL_CACHE = new ConcurrentHashMap<String, Integer>();
    public static final String DEFAULT = "waves";
    public static final int DEFAULT_SEA_LEVEL = 63;

    public List<WaveData> get() {
        return this.waves;
    }

    public void clearData() {
        this.waves.clear();
        SEA_LEVEL_CACHE.clear();
    }

    public void initConfigs() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        File subDir = new File(configPath.toString(), DEFAULT);
        JsonObject jsonObject = new JsonObject();
        this.clearData();
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        if (subDir.isDirectory()) {
            String configSubDir = subDir.getPath();
            boolean foundFile = false;
            for (File file : subDir.listFiles()) {
                if (!file.isFile() || !file.getName().equals("waves.json")) continue;
                jsonObject = JsonHelpers.readJsonFile(file.getPath());
                boolean isOld = JsonHelpers.compareVersions(JsonHelpers.getAsString(jsonObject, "version", "0")) >= 1;
                boolean shouldUpdate = JsonHelpers.getAsBoolean(jsonObject, "auto_update", false);
                if (shouldUpdate || isOld && shouldUpdate) {
                    jsonObject = JsonHelpers.createFile(configSubDir, DEFAULT, WaveDataManager.defaultConfig());
                }
                foundFile = true;
            }
            if (!foundFile) {
                jsonObject = JsonHelpers.createFile(configSubDir, DEFAULT, WaveDataManager.defaultConfig());
            }
        }
        this.waves.addAll(WaveDataManager.parseConfig(jsonObject));
    }

    public static List<WaveData> parseConfig(JsonObject jsonObject) {
        ArrayList<WaveData> waveDataList = new ArrayList<WaveData>();
        JsonArray wavesArray = jsonObject.getAsJsonArray(DEFAULT);
        for (JsonElement element : wavesArray) {
            JsonObject waveDataObject = element.getAsJsonObject();
            JsonArray dimensionsArray = waveDataObject.getAsJsonArray("dimensions");
            ArrayList<String> dimensions = new ArrayList<String>();
            for (JsonElement dimElement : dimensionsArray) {
                dimensions.add(dimElement.getAsString());
            }
            int seaLevel = waveDataObject.get("sea_level").getAsInt();
            waveDataList.add(new WaveData(dimensions, seaLevel));
        }
        return waveDataList;
    }

    public static WaveDataList readConfig(JsonObject jsonObject) {
        boolean autoUpdate = jsonObject.get("auto_update").getAsBoolean();
        String version = jsonObject.get("version").getAsString();
        JsonArray wavesArray = jsonObject.getAsJsonArray(DEFAULT);
        ArrayList<WaveData> waveDataList = new ArrayList<WaveData>();
        for (JsonElement element : wavesArray) {
            JsonObject waveDataObject = element.getAsJsonObject();
            JsonArray dimensionsArray = waveDataObject.getAsJsonArray("dimensions");
            ArrayList<String> dimensions = new ArrayList<String>();
            for (JsonElement dimElement : dimensionsArray) {
                dimensions.add(dimElement.getAsString());
            }
            int seaLevel = waveDataObject.get("sea_level").getAsInt();
            waveDataList.add(new WaveData(dimensions, seaLevel));
        }
        return new WaveDataList(autoUpdate, version, waveDataList);
    }

    public static JsonObject defaultConfig() {
        WaveData waveData = new WaveData(List.of("minecraft:overworld", "minecraft:nether", "minecraft:the_end"), 63);
        WaveDataList waveDataList = new WaveDataList(true, JsonHelpers.getVersion().toString(), List.of(waveData));
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("auto_update", Boolean.valueOf(waveDataList.autoUpdate()));
        jsonObject.addProperty("version", waveDataList.version());
        JsonArray wavesArray = new JsonArray();
        for (WaveData wd : waveDataList.waves()) {
            JsonObject waveDataObject = new JsonObject();
            JsonArray dimensionsArray = new JsonArray();
            for (String dimension : wd.dimensions()) {
                dimensionsArray.add(dimension);
            }
            waveDataObject.add("dimensions", (JsonElement)dimensionsArray);
            waveDataObject.addProperty("sea_level", (Number)wd.seaLevel());
            wavesArray.add((JsonElement)waveDataObject);
        }
        jsonObject.add(DEFAULT, (JsonElement)wavesArray);
        return jsonObject;
    }

    public int getCachedSeaLevelOrDefault(Level level) {
        ServerLevel server;
        String dimension = level.m_46472_().m_135782_().toString();
        if (SEA_LEVEL_CACHE.containsKey(dimension)) {
            return (Integer)SEA_LEVEL_CACHE.get(dimension);
        }
        for (WaveData wave : this.waves) {
            for (String dim : wave.dimensions()) {
                if (!dim.equals(dimension)) continue;
                SEA_LEVEL_CACHE.put(dimension, wave.seaLevel());
                return wave.seaLevel();
            }
        }
        if (level instanceof ServerLevel && (server = (ServerLevel)level).m_7726_() != null) {
            SEA_LEVEL_CACHE.put(dimension, server.m_7726_().m_8481_().m_6337_());
            return server.m_7726_().m_8481_().m_6337_();
        }
        SEA_LEVEL_CACHE.put(dimension, level.m_5736_());
        return level.m_5736_();
    }

    public record WaveData(List<String> dimensions, int seaLevel) {
        public static final Codec<WaveData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("dimensions", List.of("minecraft:overworld", "minecraft:nether", "minecraft:the_end")).forGetter(WaveData::dimensions), (App)Codec.INT.optionalFieldOf("sea_level", (Object)63).forGetter(WaveData::seaLevel)).apply((Applicative)instance, WaveData::new));
    }

    public record WaveDataList(boolean autoUpdate, String version, List<WaveData> waves) {
        public static final Codec<WaveDataList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("auto_update", (Object)true).forGetter(WaveDataList::autoUpdate), (App)Codec.STRING.optionalFieldOf("version", (Object)JsonHelpers.getVersion().toString()).forGetter(WaveDataList::version), (App)WaveData.CODEC.listOf().fieldOf(WaveDataManager.DEFAULT).forGetter(WaveDataList::waves)).apply((Applicative)instance, WaveDataList::new));
    }
}

