/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record HandleMaterialStats(float durability, float miningSpeed, float meleeSpeed, float attackDamage) implements IMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("handle"));
    public static final MaterialStatType<HandleMaterialStats> TYPE = new MaterialStatType<HandleMaterialStats>(ID, new HandleMaterialStats(0.0f, 0.0f, 0.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("durability", (Object)Float.valueOf(0.0f), true, HandleMaterialStats::durability), (RecordField)FloatLoadable.ANY.defaultField("mining_speed", (Object)Float.valueOf(0.0f), true, HandleMaterialStats::miningSpeed), (RecordField)FloatLoadable.ANY.defaultField("melee_speed", (Object)Float.valueOf(0.0f), true, HandleMaterialStats::meleeSpeed), (RecordField)FloatLoadable.ANY.defaultField("melee_damage", (Object)Float.valueOf(0.0f), true, HandleMaterialStats::attackDamage), HandleMaterialStats::new));
    private static final String DURABILITY_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("durability"));
    private static final String ATTACK_DAMAGE_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("attack_damage"));
    private static final String ATTACK_SPEED_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("attack_speed"));
    private static final String MINING_SPEED_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("mining_speed"));
    private static final List<Component> DESCRIPTION = List.of(IMaterialStats.makeTooltip(TConstruct.getResource("handle.durability.description")), IMaterialStats.makeTooltip(TConstruct.getResource("handle.attack_damage.description")), IMaterialStats.makeTooltip(TConstruct.getResource("handle.attack_speed.description")), IMaterialStats.makeTooltip(TConstruct.getResource("handle.mining_speed.description")));

    public MaterialStatType<HandleMaterialStats> getType() {
        return TYPE;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(HandleMaterialStats.formatDurability(this.durability));
        list.add(HandleMaterialStats.formatAttackDamage(this.attackDamage));
        list.add(HandleMaterialStats.formatAttackSpeed(this.meleeSpeed));
        list.add(HandleMaterialStats.formatMiningSpeed(this.miningSpeed));
        return list;
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.percent(builder, this.durability * scale);
        ToolStats.ATTACK_DAMAGE.percent(builder, this.attackDamage * scale);
        ToolStats.ATTACK_SPEED.percent(builder, this.meleeSpeed * scale);
        ToolStats.MINING_SPEED.percent(builder, this.miningSpeed * scale);
    }

    public static Component formatDurability(float quality) {
        return IToolStat.formatColoredPercentBoost(DURABILITY_PREFIX, quality);
    }

    public static Component formatAttackDamage(float quality) {
        return IToolStat.formatColoredPercentBoost(ATTACK_DAMAGE_PREFIX, quality);
    }

    public static Component formatAttackSpeed(float quality) {
        return IToolStat.formatColoredPercentBoost(ATTACK_SPEED_PREFIX, quality);
    }

    public static Component formatMiningSpeed(float quality) {
        return IToolStat.formatColoredPercentBoost(MINING_SPEED_PREFIX, quality);
    }

    public static Builder percents() {
        return new Builder(false);
    }

    public static Builder multipliers() {
        return new Builder(true);
    }

    public static class Builder {
        private final boolean multiplier;
        private float durability;
        private float miningSpeed;
        private float attackSpeed;
        private float attackDamage;

        private Builder(boolean multiplier) {
            float defaultValue;
            this.multiplier = multiplier;
            this.durability = defaultValue = multiplier ? 1.0f : 0.0f;
            this.miningSpeed = defaultValue;
            this.attackSpeed = defaultValue;
            this.attackDamage = defaultValue;
        }

        private static float percent(float multiplier) {
            return (float)(Math.round(multiplier * 100.0f) - 100) / 100.0f;
        }

        public HandleMaterialStats build() {
            if (this.multiplier) {
                return new HandleMaterialStats(Builder.percent(this.durability), Builder.percent(this.miningSpeed), Builder.percent(this.attackSpeed), Builder.percent(this.attackDamage));
            }
            return new HandleMaterialStats(this.durability, this.miningSpeed, this.attackSpeed, this.attackDamage);
        }

        public Builder durability(float durability) {
            this.durability = durability;
            return this;
        }

        public Builder miningSpeed(float miningSpeed) {
            this.miningSpeed = miningSpeed;
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.attackSpeed = attackSpeed;
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }
    }
}

