/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.stats.ToolType;

public class DwarvenModifier
extends Modifier
implements ConditionalStatModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final Component VELOCITY = TConstruct.makeTranslation("modifier", "dwarven.velocity");
    private static final float BOOST_DISTANCE = 64.0f;
    private static final float DEBUFF_RANGE = 128.0f;
    private static final float MINING_BONUS = 6.0f;
    private static final float VELOCITY_BONUS = 0.05f;
    private static final ToolType[] TYPES = new ToolType[]{ToolType.RANGED, ToolType.MELEE};

    @Override
    public int getPriority() {
        return 85;
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.BREAK_SPEED, ModifierHooks.TOOLTIP);
    }

    private static float getBoost(Level world, float y, ModifierEntry entry, float baseSpeed, float bonus) {
        if (y < 64.0f) {
            float scale = Mth.m_14036_((float)((64.0f - y) / 64.0f), (float)0.0f, (float)2.0f);
            return baseSpeed + entry.getEffectiveLevel() * scale * bonus;
        }
        float baselineDebuff = Math.max((float)world.m_151558_() - 192.0f, 96.0f);
        if (y > baselineDebuff) {
            if (y >= baselineDebuff + 128.0f) {
                return baseSpeed * 0.25f;
            }
            return baseSpeed * (1.0f - (y - baselineDebuff) / 128.0f * 0.75f);
        }
        return baseSpeed;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Optional pos = event.getPosition();
        if (!isEffective || pos.isEmpty()) {
            return;
        }
        event.setNewSpeed(DwarvenModifier.getBoost(event.getEntity().m_9236_(), ((BlockPos)pos.get()).m_123342_(), modifier, event.getNewSpeed(), miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED) * 6.0f));
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            return DwarvenModifier.getBoost(living.m_9236_(), (float)living.m_20186_(), modifier, baseValue, multiplier * 0.05f);
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        ToolType type = ToolType.from(tool.getItem(), TYPES);
        if (type != null) {
            double boost;
            float baseBoost;
            Component prefix = type == ToolType.RANGED ? VELOCITY : MINING_SPEED;
            float f = baseBoost = type == ToolType.RANGED ? 0.05f : 6.0f;
            if (player != null && key == TooltipKey.SHIFT) {
                boost = DwarvenModifier.getBoost(player.m_9236_(), (float)player.m_20186_(), modifier, 1.0f, baseBoost) - 1.0f;
                if (boost < 0.0) {
                    if (boost <= -0.01) {
                        TooltipModifierHook.addPercentBoost(this, prefix, boost, tooltip);
                    }
                    return;
                }
            } else {
                boost = baseBoost * (float)modifier.getLevel();
            }
            if (boost >= 0.01) {
                TooltipModifierHook.addFlatBoost(this, prefix, boost * (double)tool.getMultiplier(type == ToolType.RANGED ? ToolStats.VELOCITY : ToolStats.MINING_SPEED), tooltip);
            }
        }
    }
}

