/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.general;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.general.FluidEffectListBuilder;

public record SequenceFluidEffect<C extends FluidEffectContext>(List<FluidEffect<? super C>> effects, RecordLoadable<SequenceFluidEffect<C>> getLoader) implements FluidEffect<C>
{
    public static final RecordLoadable<SequenceFluidEffect<FluidEffectContext.Block>> BLOCK_LOADER = SequenceFluidEffect.createLoader(FluidEffectListBuilder.BLOCK_EFFECT_LIST);
    public static final RecordLoadable<SequenceFluidEffect<FluidEffectContext.Entity>> ENTITY_LOADER = SequenceFluidEffect.createLoader(FluidEffectListBuilder.ENTITY_EFFECT_LIST);

    @Override
    public float apply(FluidStack fluid, EffectLevel level, C context, IFluidHandler.FluidAction action) {
        FluidEffect<? super C> effect;
        float applied;
        float maxApplied = 0.0f;
        Iterator<FluidEffect<C>> iterator = this.effects.iterator();
        while (iterator.hasNext() && !((applied = (effect = iterator.next()).apply(fluid, level, (FluidEffectContext)context, action)) <= 0.0f)) {
            if (!(applied > maxApplied)) continue;
            maxApplied = applied;
        }
        return maxApplied;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return this.effects.stream().map(effect -> effect.getDescription(registryAccess)).reduce(MERGE_COMPONENT_LIST).orElse((Component)Component.m_237119_());
    }

    public static FluidEffectListBuilder<FluidEffectContext.Block, SequenceFluidEffect<FluidEffectContext.Block>> blocks() {
        return FluidEffectListBuilder.builder(list -> new SequenceFluidEffect<FluidEffectContext.Block>((List<FluidEffect<FluidEffectContext.Block>>)list, BLOCK_LOADER));
    }

    public static FluidEffectListBuilder<FluidEffectContext.Entity, SequenceFluidEffect<FluidEffectContext.Entity>> entities() {
        return FluidEffectListBuilder.builder(list -> new SequenceFluidEffect<FluidEffectContext.Entity>((List<FluidEffect<FluidEffectContext.Entity>>)list, ENTITY_LOADER));
    }

    public static <C extends FluidEffectContext> RecordLoadable<SequenceFluidEffect<C>> createLoader(Loadable<List<FluidEffect<? super C>>> effectList) {
        return RecordLoadable.withLoader((RecordField)effectList.requiredField("effects", SequenceFluidEffect::effects), SequenceFluidEffect::new);
    }
}

