/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@NothingNullByDefault
public class BinInsertRecipe
extends BinRecipe {
    public BinInsertRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack binStack = ItemStack.f_41583_;
        ItemStack foundType = ItemStack.f_41583_;
        int slots = inv.m_6643_();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.m_41619_()) {
                foundType = stackInSlot;
                continue;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) continue;
            return false;
        }
        if (binStack.m_41619_() || foundType.m_41619_()) {
            return false;
        }
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        ItemStack remaining = slot.insertItem(foundType, Action.SIMULATE, AutomationType.MANUAL);
        return !ItemStack.m_41728_((ItemStack)remaining, (ItemStack)foundType);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack binStack = ItemStack.f_41583_;
        ItemStack foundType = ItemStack.f_41583_;
        ArrayList<ItemStack> foundItems = new ArrayList<ItemStack>();
        int slots = inv.m_6643_();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.m_41619_()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return ItemStack.f_41583_;
            }
            foundItems.add(stackInSlot);
        }
        if (binStack.m_41619_() || foundType.m_41619_()) {
            return ItemStack.f_41583_;
        }
        binStack = binStack.m_41777_();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        boolean hasInserted = false;
        for (ItemStack stack : foundItems) {
            ItemStack toInsert = stack.m_255036_(1);
            ItemStack remainder = slot.insertItem(toInsert, Action.EXECUTE, AutomationType.MANUAL);
            if (remainder.m_41619_()) {
                hasInserted = true;
                continue;
            }
            if (hasInserted) {
                return binStack;
            }
            return ItemStack.f_41583_;
        }
        ItemDataUtils.setBoolean(binStack, "fromRecipe", true);
        return binStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        int slots = inv.m_6643_();
        NonNullList remainingItems = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
        ItemStack binStack = ItemStack.f_41583_;
        ItemStack foundType = ItemStack.f_41583_;
        Int2ObjectArrayMap foundSlots = new Int2ObjectArrayMap(slots);
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return remainingItems;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.m_41619_()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return remainingItems;
            }
            foundSlots.put(i, (Object)stackInSlot);
        }
        if (binStack.m_41619_() || foundType.m_41619_()) {
            return remainingItems;
        }
        binStack = binStack.m_41777_();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        for (Int2ObjectMap.Entry entry : foundSlots.int2ObjectEntrySet()) {
            ItemStack slotItem = (ItemStack)entry.getValue();
            ItemStack remaining = slot.insertItem(slotItem.m_255036_(1), Action.EXECUTE, AutomationType.MANUAL);
            if (remaining.m_41619_()) continue;
            remainingItems.set(entry.getIntKey(), (Object)remaining);
        }
        return remainingItems;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MekanismRecipeSerializers.BIN_INSERT.get();
    }

    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (!result.m_41619_() && result.m_41720_() instanceof ItemBlockBin && ItemDataUtils.getBoolean(result, "fromRecipe")) {
            BinInventorySlot slot = BinInsertRecipe.convertToSlot(result);
            ItemStack storedStack = slot.getStack();
            if (!storedStack.m_41619_()) {
                Container craftingMatrix = event.getInventory();
                int slots = craftingMatrix.m_6643_();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stack = craftingMatrix.m_8020_(i);
                    if (stack.m_41613_() <= 1 || !ItemHandlerHelper.canItemStacksStack((ItemStack)storedStack, (ItemStack)stack)) continue;
                    ItemStack toInsert = stack.m_255036_(stack.m_41613_() - 1);
                    ItemStack remaining = slot.insertItem(toInsert, Action.EXECUTE, AutomationType.MANUAL);
                    if (remaining.m_41619_()) {
                        craftingMatrix.m_6836_(i, stack.m_255036_(1));
                        continue;
                    }
                    if (remaining.m_41613_() >= toInsert.m_41613_()) continue;
                    craftingMatrix.m_6836_(i, stack.m_255036_(remaining.m_41613_() + 1));
                }
            }
            ItemDataUtils.removeData(result, "fromRecipe");
        }
    }
}

