/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class MapLoadable<K, V>
implements Loadable<Map<K, V>> {
    protected final StringLoadable<K> keyLoadable;
    protected final Loadable<V> valueLoadable;
    protected final int minSize;

    public MapLoadable(StringLoadable<K> keyLoadable, Loadable<V> valueLoadable, int minSize) {
        this.keyLoadable = keyLoadable;
        this.valueLoadable = valueLoadable;
        this.minSize = minSize;
    }

    protected Map<K, V> build(Map<K, V> builder) {
        return Map.copyOf(builder);
    }

    protected Map<K, V> createBuilder(int size) {
        return new HashMap(size);
    }

    @Override
    public Map<K, V> convert(JsonElement element, String key, TypedMap context) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)key);
        if (json.size() < this.minSize) {
            throw new JsonSyntaxException(key + " must have at least " + this.minSize + " elements");
        }
        Map<K, V> builder = this.createBuilder(json.size());
        String mapKey = key + "'s key";
        for (Map.Entry entry : json.entrySet()) {
            String entryKey = (String)entry.getKey();
            builder.put(this.keyLoadable.parseString(entryKey, mapKey), this.valueLoadable.convert((JsonElement)entry.getValue(), entryKey, context));
        }
        return this.build(builder);
    }

    @Override
    public JsonElement serialize(Map<K, V> map) {
        if (map.size() < this.minSize) {
            throw new RuntimeException("Collection must have at least " + this.minSize + " elements");
        }
        JsonObject json = new JsonObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            json.add(this.keyLoadable.getString(entry.getKey()), this.valueLoadable.serialize(entry.getValue()));
        }
        return json;
    }

    @Override
    public Map<K, V> decode(FriendlyByteBuf buffer, TypedMap context) {
        int size = buffer.m_130242_();
        Map<Object, Object> builder = this.createBuilder(size);
        for (int i = 0; i < size; ++i) {
            builder.put(this.keyLoadable.decode(buffer, context), this.valueLoadable.decode(buffer, context));
        }
        return this.build(builder);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Map<K, V> map) {
        buffer.m_130130_(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keyLoadable.encode(buffer, entry.getKey());
            this.valueLoadable.encode(buffer, entry.getValue());
        }
    }

    public <P> LoadableField<Map<K, V>, P> emptyField(String key, boolean serializeEmpty, Function<P, Map<K, V>> getter) {
        return this.defaultField(key, Map.of(), serializeEmpty, getter);
    }

    public <P> LoadableField<Map<K, V>, P> emptyField(String key, Function<P, Map<K, V>> getter) {
        return this.emptyField(key, false, getter);
    }

    public String toString() {
        return "MapLoadable[keyLoadable=" + this.keyLoadable + ", valueLoadable=" + this.valueLoadable + ", minSize=" + this.minSize + "]";
    }
}

