/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.block.loader.KBlockTemplates;
import snownee.kiwi.customization.block.loader.KMaterial;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class SimpleBlockTemplate
extends KBlockTemplate {
    private final String clazz;
    private Function<BlockBehaviour.Properties, Block> constructor;

    public SimpleBlockTemplate(Optional<BlockDefinitionProperties> properties, String clazz) {
        super(properties);
        this.clazz = clazz;
    }

    public static Codec<SimpleBlockTemplate> directCodec(MapCodec<Optional<KMaterial>> materialCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)BlockDefinitionProperties.mapCodecField(materialCodec).forGetter(KBlockTemplate::properties), (App)Codec.STRING.optionalFieldOf("class", (Object)"").forGetter(SimpleBlockTemplate::clazz)).apply((Applicative)instance, SimpleBlockTemplate::new));
    }

    @Override
    public KBlockTemplate.Type<?> type() {
        return KBlockTemplates.SIMPLE.getOrCreate();
    }

    @Override
    public void resolve(ResourceLocation key, OneTimeLoader.Context context) {
        if (this.clazz.isEmpty()) {
            this.constructor = BlockCodecs.SIMPLE_BLOCK_FACTORY;
            return;
        }
        try {
            Class<?> clazz = Class.forName(context.mappingResolver().unmapClass(this.clazz));
            this.constructor = $ -> {
                try {
                    return (Block)clazz.getConstructor(BlockBehaviour.Properties.class).newInstance($);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Block createBlock(ResourceLocation id, BlockBehaviour.Properties settings, JsonObject input) {
        return this.constructor.apply(settings);
    }

    public String clazz() {
        return this.clazz;
    }

    public String toString() {
        return "SimpleBlockTemplate[properties=" + this.properties + ", clazz=" + this.clazz + ", constructor=" + this.constructor + "]";
    }
}

