/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.item.ItemCategoryFiller;

public class GroupSetting {
    private final String[] groups;
    private final String[] after;
    private final List<ItemCategoryFiller> fillers = Lists.newArrayList();

    public static GroupSetting of(KiwiModule.Category category, GroupSetting preset) {
        if (preset != null) {
            if (category.value().length == 0 && category.after().length == 0) {
                return preset;
            }
            if (category.value().length == 0) {
                return new GroupSetting(preset.groups, category.after());
            }
        }
        return new GroupSetting(category.value(), category.after());
    }

    public GroupSetting(String[] groups, String[] after) {
        this.groups = groups;
        this.after = after;
    }

    public void apply(ItemCategoryFiller filler) {
        this.fillers.add(filler);
    }

    public void postApply() {
        List<ResourceKey> tabKeys = Stream.of(this.groups).map($ -> {
            CreativeModeTab tab = Kiwi.getGroup($);
            if (tab != null) {
                return BuiltInRegistries.f_279662_.m_7854_((Object)tab).orElse(null);
            }
            return ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation($));
        }).filter(Objects::nonNull).toList();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        for (ResourceKey tabKey : tabKeys) {
            eventBus.addListener(event -> {
                if (!event.getTabKey().equals((Object)tabKey)) {
                    return;
                }
                List<Item> afterItems = Stream.of(this.after).map(ResourceLocation::m_135820_).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).filter(Predicate.not(Items.f_41852_::equals)).toList();
                List<Object> items = Lists.newArrayList();
                for (ItemCategoryFiller filler : this.fillers) {
                    CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(tabKey);
                    filler.fillItemCategory(tab, event.getFlags(), event.hasPermissions(), items);
                }
                items = GroupSetting.getEnabledStacks(items, event.getFlags());
                GroupSetting.addAfter(items, (MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries(), afterItems);
            });
        }
    }

    private static void addAfter(List<ItemStack> toAdd, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, Collection<Item> afterItems) {
        ItemStack lastFound = ItemStack.f_41583_;
        for (Item item : afterItems) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!map.contains((Object)stack)) continue;
            lastFound = stack;
        }
        ItemStack prev = ItemStack.f_41583_;
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack item = toAdd.get(i);
            if (i == 0) {
                if (lastFound.m_41619_()) {
                    map.put((Object)item, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                } else {
                    map.putAfter((Object)lastFound, (Object)item, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            } else {
                map.putAfter((Object)prev, (Object)item, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
            prev = item;
        }
    }

    private static List<ItemStack> getEnabledStacks(List<ItemStack> newStacks, FeatureFlagSet enabledFeatures) {
        if (newStacks.stream().allMatch($ -> GroupSetting.isEnabled($, enabledFeatures))) {
            return newStacks;
        }
        return newStacks.stream().filter($ -> GroupSetting.isEnabled($, enabledFeatures)).toList();
    }

    private static boolean isEnabled(ItemStack stack, FeatureFlagSet enabledFeatures) {
        return stack.m_41720_().m_245993_(enabledFeatures);
    }
}

