/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.split.BakedBasicSplitModel;
import blusunrize.immersiveengineering.client.models.split.BakedDynamicSplitModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;

public class UnbakedSplitModel
implements IUnbakedGeometry<UnbakedSplitModel> {
    private final UnbakedModel baseModel;
    private final Set<Vec3i> parts;
    private final boolean dynamic;
    @Nonnull
    private final Vec3i size;

    public UnbakedSplitModel(UnbakedModel baseModel, List<Vec3i> parts, boolean dynamic, @NotNull Vec3i size) {
        this.baseModel = baseModel;
        this.parts = new HashSet<Vec3i>(parts);
        this.dynamic = dynamic;
        this.size = size;
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel bakedBase = this.baseModel.m_7611_(bakery, spriteGetter, (ModelState)BlockModelRotation.X0_Y0, modelLocation);
        if (this.dynamic) {
            return new BakedDynamicSplitModel((ICacheKeyProvider)bakedBase, this.parts, modelTransform, this.size);
        }
        return new BakedBasicSplitModel(bakedBase, this.parts, modelTransform, this.size, owner.getTransforms());
    }
}

