/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class BlastFurnaceFuel
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<BlastFurnaceFuel>> SERIALIZER;
    public static final CachedRecipeList<BlastFurnaceFuel> RECIPES;
    public final Ingredient input;
    public final int burnTime;

    public BlastFurnaceFuel(ResourceLocation id, Ingredient input, int burnTime) {
        super((Lazy<ItemStack>)LAZY_EMPTY, IERecipeTypes.BLAST_FUEL, id);
        this.input = input;
        this.burnTime = burnTime;
    }

    public static int getBlastFuelTime(Level level, ItemStack stack) {
        for (BlastFurnaceFuel e : RECIPES.getRecipes(level)) {
            if (!e.input.test(stack)) continue;
            return e.burnTime;
        }
        return 0;
    }

    public static boolean isValidBlastFuel(Level level, ItemStack stack) {
        return BlastFurnaceFuel.getBlastFuelTime(level, stack) > 0;
    }

    protected IERecipeSerializer<BlastFurnaceFuel> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    static {
        RECIPES = new CachedRecipeList<BlastFurnaceFuel>(IERecipeTypes.BLAST_FUEL);
    }
}

