/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.trees;

import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.util.Optional;
import java.util.function.Supplier;
import maxhyper.dttwilightforest.blocks.MagicCoreBranchBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class MagicFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(MagicFamily::new);
    private Supplier<BranchBlock> coreBranch;
    private Block primitiveCoreLog = Blocks.f_50016_;

    public MagicFamily(ResourceLocation name) {
        super(name);
    }

    public void setupBlocks() {
        super.setupBlocks();
        this.setCoreBranch(this.createCoreBranch(ResourceLocationUtils.suffix((ResourceLocation)this.getRegistryName(), (String)"_core")));
    }

    protected Family setCoreBranch(Supplier<BranchBlock> branch) {
        this.coreBranch = this.setupBranch(branch, false);
        return this;
    }

    protected Supplier<BranchBlock> createCoreBranch(ResourceLocation name) {
        return RegistryHandler.addBlock((ResourceLocation)ResourceLocationUtils.suffix((ResourceLocation)name, (String)this.getBranchNameSuffix()), () -> this.createCoreBranchBlock(name));
    }

    protected BranchBlock createCoreBranchBlock(ResourceLocation name) {
        MagicCoreBranchBlock branch = new MagicCoreBranchBlock(name, this.getProperties(), MagicCoreBranchBlock.coreType.valueOf(this.getRegistryName().m_135815_().toUpperCase()));
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    public Family setPrimitiveCoreLog(Block primitiveCoreLog) {
        this.primitiveCoreLog = primitiveCoreLog;
        if (this.coreBranch != null) {
            this.coreBranch.get().setPrimitiveLogDrops(new ItemStack[]{new ItemStack((ItemLike)primitiveCoreLog)});
        }
        return this;
    }

    public Optional<Block> getPrimitiveCoreLog() {
        return Optionals.ofBlock((Block)this.primitiveCoreLog);
    }

    public Optional<BranchBlock> getCoreBranch() {
        return Optionals.ofBlock(this.coreBranch);
    }
}

