/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MiningTreeLogic
extends GrowthLogicKit {
    public MiningTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_VARIATION, (Object)3);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{HEIGHT_VARIATION});
    }

    private Direction getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
        if (signalPos.m_123343_() < rootPos.m_123343_()) {
            return Direction.NORTH;
        }
        if (signalPos.m_123343_() > rootPos.m_123343_()) {
            return Direction.SOUTH;
        }
        if (signalPos.m_123341_() > rootPos.m_123341_()) {
            return Direction.EAST;
        }
        if (signalPos.m_123341_() < rootPos.m_123341_()) {
            return Direction.WEST;
        }
        return Direction.UP;
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        BlockPos pos = context.pos();
        GrowSignal signal = context.signal();
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        Level level = context.level();
        Direction originDir = signal.dir.m_122424_();
        int lowestBranch = this.getLowestBranchHeight(configuration, new PositionalSpeciesContext(context.level(), signal.rootPos, context.species()));
        if (pos.m_123342_() >= signal.rootPos.m_123342_() + lowestBranch || !signal.isInTrunk()) {
            probMap[Direction.UP.ordinal()] = 0;
            for (Iterator dir : Direction.Plane.HORIZONTAL) {
                if (!TreeHelper.isBranch((BlockState)level.m_8055_(pos.m_121955_(dir.m_122436_())))) continue;
                probMap[dir.m_175364_((Direction.Axis)Direction.Axis.Y).ordinal()] = 0;
                probMap[dir.m_175362_((Direction.Axis)Direction.Axis.Y).ordinal()] = 0;
            }
        }
        if (!signal.isInTrunk()) {
            Direction[] sides;
            Direction relativePosToRoot = this.getRelativeFace(pos, signal.rootPos);
            for (Direction[] dir : Direction.Plane.HORIZONTAL) {
                probMap[dir.ordinal()] = 0;
            }
            for (Direction dirSides : sides = new Direction[]{relativePosToRoot.m_175362_(Direction.Axis.Y), relativePosToRoot.m_175364_(Direction.Axis.Y), Direction.UP}) {
                if (!level.m_46859_(pos.m_121955_(dirSides.m_122436_())) || TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos) <= 1) continue;
                probMap[dirSides.ordinal()] = 1;
            }
            boolean isBranchSide = TreeHelper.isBranch((BlockState)level.m_8055_(pos.m_121955_(relativePosToRoot.m_122436_())));
            boolean isBranchDown = TreeHelper.isBranch((BlockState)level.m_8055_(pos.m_7495_()));
            probMap[Direction.DOWN.ordinal()] = isBranchSide && !isBranchDown ? 0 : 1;
            probMap[relativePosToRoot.ordinal()] = isBranchDown && !isBranchSide ? 0 : 1;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + this.getHashVariation(configuration, context));
    }

    protected float getHashVariation(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.level().m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)context.pos().m_6630_(month), (int)2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }
}

