/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.blocks;

import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import java.util.Optional;
import maxhyper.dttwilightforest.trees.TwilightMangroveFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.Nullable;

public class TwilightMangroveRootsBlock
extends BasicRootsBlock {
    public static final BooleanProperty GRASSY = BooleanProperty.m_61465_((String)"grassy");

    public TwilightMangroveRootsBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties.m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)GRASSY, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{GRASSY});
    }

    public TwilightMangroveFamily getFamily() {
        return (TwilightMangroveFamily)super.getFamily();
    }

    private Optional<Block> getPrimitiveGrassIfGrassy(BlockState state) {
        if (this.isFullBlock(state) && state.m_61138_((Property)GRASSY) && ((Boolean)state.m_61143_((Property)GRASSY)).booleanValue()) {
            return this.getFamily().getPrimitiveGrassyRoots();
        }
        return Optional.empty();
    }

    private Block getPrimitiveAny(BlockState state) {
        return this.getPrimitiveGrassIfGrassy(state).orElseGet(() -> ((BasicRootsBlock.Layer)state.m_61143_((Property)LAYER)).getPrimitive((MangroveFamily)this.getFamily()).orElse(null));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.isFullBlock(state)) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)LAYER, (Comparable)BasicRootsBlock.Layer.EXPOSED)).m_61124_((Property)GRASSY, (Comparable)Boolean.valueOf(false)), level.f_46443_ ? 11 : 3);
            this.m_142387_(level, player, pos, state);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            Block primitive = this.getPrimitiveAny(state);
            if (!player.m_7500_() && primitive != null) {
                TwilightMangroveRootsBlock.m_49881_((BlockState)primitive.m_49966_(), (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
            return false;
        }
        return this.removedByEntity(state, level, pos, (LivingEntity)player);
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @javax.annotation.Nullable Direction originDir, int flags) {
        int rad = super.setRadius(level, pos, radius, originDir, flags);
        BlockState newBranchState = level.m_8055_(pos);
        if (newBranchState.m_60713_((Block)this) && newBranchState.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.COVERED) {
            level.m_7731_(pos, (BlockState)newBranchState.m_61124_((Property)GRASSY, (Comparable)Boolean.valueOf(this.canBeGrassy(level, pos))), flags);
        }
        return rad;
    }

    protected boolean canBeGrassy(LevelAccessor level, BlockPos pos) {
        BlockPos upPos = pos.m_7494_();
        BlockState upState = level.m_8055_(upPos);
        return !upState.m_60838_((BlockGetter)level, upPos) && upState.m_60819_().m_76178_();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (!state.m_60713_((Block)this) || state.m_61143_((Property)LAYER) != BasicRootsBlock.Layer.COVERED) {
            return;
        }
        int requiredLight = this.getFamily().getGrassSpreadRequiredLight();
        if (!level.f_46443_) {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!this.canBeGrassy((LevelAccessor)level, pos)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)GRASSY, (Comparable)Boolean.valueOf(false)), 3);
            } else if (level.m_46803_(pos.m_7494_()) >= requiredLight) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos thatPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                    if (!level.m_46805_(thatPos)) {
                        return;
                    }
                    BlockState thatState = level.m_8055_(thatPos);
                    Block block = this.getFamily().getPrimitiveGrassyRoots().orElse(null);
                    if (block == null || thatState.m_60734_() != block) continue;
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)GRASSY, (Comparable)Boolean.valueOf(true)), 3);
                    return;
                }
            }
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return super.canSustainPlant(state, world, pos, facing, plantable) || state.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.COVERED;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        Optional<Block> primitiveGrass = this.getPrimitiveGrassIfGrassy(state);
        if (primitiveGrass.isPresent()) {
            return primitiveGrass.get().getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Optional<Block> primitiveGrass = this.getPrimitiveGrassIfGrassy(state);
        if (primitiveGrass.isPresent()) {
            return primitiveGrass.get().getCloneItemStack(state, target, level, pos, player);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

