/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.tree;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.item.Seed;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictreesplus.DynamicTreesPlus;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.init.DTPConfigs;
import com.ferreusveritas.dynamictreesplus.init.DTPRegistries;
import com.ferreusveritas.dynamictreesplus.items.FoodSeed;
import com.ferreusveritas.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;

public class CactusSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = CactusSpecies.createDefaultType(CactusSpecies::new);
    private CactusThicknessLogic thicknessLogic;
    private boolean isSeedEdible = false;

    public CactusSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public Species setPreReloadDefaults() {
        this.setTransformable(false);
        return this.setSaplingShape(DTPRegistries.MEDIUM_CACTUS_SAPLING_SHAPE).setSaplingSound(SoundType.f_56745_).setDefaultGrowingParameters().envFactor(Tags.Biomes.IS_SNOWY, 0.25f).envFactor(Tags.Biomes.IS_COLD, 0.5f).envFactor(Tags.Biomes.IS_SANDY, 1.05f).setGrowthLogicKit((GrowthLogicKit)DTPRegistries.STRAIGHT_LOGIC);
    }

    public Species setPostReloadDefaults() {
        if (this.thicknessLogic == null) {
            this.thicknessLogic = (CactusThicknessLogic)CactusThicknessLogic.REGISTRY.get(this.getRegistryName());
        }
        return super.setPostReloadDefaults();
    }

    public void setThicknessLogic(CactusThicknessLogic thicknessLogic) {
        this.thicknessLogic = thicknessLogic;
    }

    public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(Level level, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
        return this.thicknessLogic.thicknessAfterGrowthSignal(level, pos, signal, currentThickness);
    }

    public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(LevelAccessor level, BlockPos pos, boolean isLast) {
        return this.thicknessLogic.thicknessForBranchPlaced(level, pos, isLast);
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils(new String[]{"sand_like"});
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCodeCactus(joCodeString);
    }

    public boolean isBiomePerfect(Holder<Biome> biome) {
        return this.perfectBiomes.m_203632_() > 0 ? super.isBiomePerfect(biome) : biome.m_203656_(Tags.Biomes.IS_DRY) && biome.m_203656_(Tags.Biomes.IS_SANDY);
    }

    public boolean handleRot(LevelAccessor level, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, SafeChunkBounds safeBounds) {
        return false;
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        this.placeRootyDirtBlock((LevelAccessor)level, pos.m_7495_(), 15);
        family.getBranch().ifPresent(branch -> level.m_46597_(pos, (BlockState)branch.m_49966_().m_61124_(CactusBranchBlock.TRUNK_TYPE, (Comparable)((Object)this.thicknessForBranchPlaced((LevelAccessor)level, pos, false)))));
        return true;
    }

    public boolean canBoneMealTree() {
        return (Boolean)DTPConfigs.CAN_BONE_MEAL_CACTUS.get();
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        return DynamicTreesPlus.location("block/smart_model/" + this.thicknessLogic.getRegistryName().m_135815_() + "_cactus");
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation sideLoc = this.getFamily().getTexturePath("branch").orElse(ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_side"));
        ResourceLocation topLoc = this.getFamily().getTexturePath("branch_top").orElse(ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_top"));
        ResourceLocation botLoc = this.getFamily().getTexturePath("branch_bottom").orElse(ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_bottom"));
        textureConsumer.accept("side", sideLoc);
        textureConsumer.accept("top", topLoc);
        textureConsumer.accept("bottom", botLoc);
    }

    public boolean shouldGenerateVoluntaryDrops() {
        return false;
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed((Supplier)RegistryHandler.addItem((ResourceLocation)this.getSeedName(), this::createSeedItem));
    }

    public Seed createSeedItem() {
        return this.isSeedEdible ? new FoodSeed(this) : new Seed((Species)this);
    }

    public void setSeedEdible(boolean edible) {
        this.isSeedEdible = edible;
    }

    private static class JoCodeCactus
    extends JoCode {
        public JoCodeCactus(String code) {
            super(code);
        }

        public void generate(GenerationContext context) {
            LevelAccessor level = context.level();
            BlockPos.MutableBlockPos rootPos = context.rootPos();
            BlockState initialDirtState = level.m_8055_((BlockPos)rootPos);
            context.species().placeRootyDirtBlock(level, (BlockPos)rootPos, 0);
            int radius = Mth.m_14045_((int)context.radius(), (int)2, (int)8);
            BlockPos treePos = rootPos.m_7494_();
            this.setFacing(context.facing());
            this.generateFork(level, context.species(), 0, (BlockPos)rootPos, false);
            BranchBlock branch = TreeHelper.getBranch((BlockState)level.m_8055_(treePos));
            if (branch != null) {
                FindEndsNode endFinder = new FindEndsNode();
                MapSignal signal = new MapSignal(new NodeInspector[]{endFinder});
                branch.analyse(level.m_8055_(treePos), level, treePos, Direction.DOWN, signal);
                List endPoints = endFinder.getEnds();
                context.species().postGeneration(new PostGenerationContext(context, endPoints, initialDirtState));
                MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(level, context.species(), (BlockPos)rootPos, endPoints, context.safeBounds(), initialDirtState));
            } else {
                level.m_7731_((BlockPos)rootPos, initialDirtState, this.careful ? 3 : 2);
            }
        }

        public boolean setBlockForGeneration(LevelAccessor level, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
            boolean replace;
            Optional branch = species.getFamily().getBranch();
            if (!(species instanceof CactusSpecies) || !branch.isPresent()) {
                return false;
            }
            BlockState defaultBranchState = ((BranchBlock)branch.get()).m_49966_();
            BlockState replaceState = level.m_8055_(pos);
            boolean bl = replace = replaceState.m_60795_() || replaceState.m_204336_(BlockTags.f_13035_) || replaceState.m_60713_(Blocks.f_50440_) || replaceState.m_204336_(BlockTags.f_144274_) || replaceState.m_204336_(BlockTags.f_13106_) || replaceState.m_204336_(BlockTags.f_13104_) || replaceState.m_60713_(Blocks.f_50191_);
            if (replace && (!careful || this.isClearOfNearbyBranches(level, pos, dir.m_122424_()))) {
                CactusBranchBlock.CactusThickness trunk = ((CactusSpecies)species).thicknessForBranchPlaced(level, pos, isLast);
                return !level.m_7731_(pos, (BlockState)((BlockState)defaultBranchState.m_61124_(CactusBranchBlock.TRUNK_TYPE, (Comparable)((Object)trunk))).m_61124_(CactusBranchBlock.ORIGIN, (Comparable)dir.m_122424_()), careful ? 3 : 2);
            }
            return true;
        }
    }
}

