/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.model.baked;

import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class CactusBranchBlockBakedModel
implements IDynamicBakedModel {
    private final BlockModel blockModel;
    private final ResourceLocation modelLocation;
    private final TextureAtlasSprite barkTexture;
    private final BakedModel[][] sleeves = new BakedModel[6][3];
    private final BakedModel[][] cores = new BakedModel[3][3];
    private final BakedModel[] rings = new BakedModel[3];
    private final BakedModel[] coreSpikes = new BakedModel[3];
    private BakedModel sleeveTopSpikes;
    int[] radii = new int[]{4, 5, 7};

    public CactusBranchBlockBakedModel(ResourceLocation modelLocation, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.modelLocation = modelLocation;
        this.barkTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, barkTextureLocation));
        this.initModels(spriteGetter.apply(new Material(InventoryMenu.f_39692_, ringsTextureLocation)));
    }

    public void initModels(TextureAtlasSprite ringsTexture) {
        for (int i = 0; i < 3; ++i) {
            int radius = this.radii[i];
            for (Direction dir : Direction.values()) {
                this.sleeves[dir.m_122411_()][i] = this.bakeSleeve(radius, dir, this.barkTexture, ringsTexture);
            }
            this.cores[0][i] = this.bakeCore(radius, Direction.Axis.Y, this.barkTexture);
            this.cores[1][i] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[2][i] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
            this.rings[i] = this.bakeCore(radius, Direction.Axis.Y, ringsTexture);
            this.coreSpikes[i] = this.bakeCoreSpikes(radius, this.barkTexture);
            this.sleeveTopSpikes = this.bakeTopSleeveSpikes(this.barkTexture);
        }
    }

    private void putVertex(QuadBakingVertexConsumer builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, Direction face) {
        builder.m_5483_(x, y, z);
        builder.m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_);
        builder.m_85950_(r, g, b, 1.0f);
        builder.m_7421_(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
        builder.setSprite(sprite);
        builder.setDirection(face);
        builder.m_5752_();
    }

    private BakedQuad createQuad(Vec3 v1, float v1u, float v1v, Vec3 v2, float v2u, float v2v, Vec3 v3, float v3u, float v3v, Vec3 v4, float v4u, float v4v, TextureAtlasSprite sprite) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        QuadBakingVertexConsumer.Buffered builder = new QuadBakingVertexConsumer.Buffered();
        Direction face = Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_);
        this.putVertex((QuadBakingVertexConsumer)builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, v1u, v1v, sprite, 1.0f, 1.0f, 1.0f, face);
        this.putVertex((QuadBakingVertexConsumer)builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, v2u, v2v, sprite, 1.0f, 1.0f, 1.0f, face);
        this.putVertex((QuadBakingVertexConsumer)builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, v3u, v3v, sprite, 1.0f, 1.0f, 1.0f, face);
        this.putVertex((QuadBakingVertexConsumer)builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, v4u, v4v, sprite, 1.0f, 1.0f, 1.0f, face);
        return builder.getQuad();
    }

    public BakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark, TextureAtlasSprite top) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.m_122429_() != 0 ? halfSize : dradius;
        int halfSizeY = dir.m_122430_() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.m_122431_() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.m_122429_() * move;
        int centerY = 16 + dir.m_122430_() * move;
        int centerZ = 16 + dir.m_122431_() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        boolean bl = negative = dir.m_122421_() == Direction.AxisDirection.NEGATIVE;
        if (dir.m_122434_() == Direction.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.m_122424_() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 4 || radius == 5 && dir == Direction.DOWN) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.m_122434_(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(bark);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.m_119530_(face, ModelUtils.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)(dir == face ? top : bark), (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        float minV = negative ? (float)(16 - halfSize) : 0.0f;
        float maxV = negative ? 16.0f : (float)halfSize;
        switch (dir.m_122434_()) {
            case X: {
                builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 16.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 14.0f, minV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 14.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 16.0f, maxV, bark));
                builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 2.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 0.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 0.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 2.0f, maxV, bark));
                builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 16.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 14.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 14.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 16.0f, minV, bark));
                builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 2.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 0.0f, maxV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 2.0f, minV, bark));
                builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, bark));
                builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, bark));
                builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, bark));
                builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f - 0.0625f), 2.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f + 0.0625f), 0.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f + 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f - 0.0625f), 2.0f, minV, bark));
                break;
            }
            case Y: {
                builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, bark));
                builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, bark));
                builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, bark));
                builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, bark));
                builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 16.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 14.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 16.0f, minV, bark));
                builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 2.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 2.0f, minV, bark));
                builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 16.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 14.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 16.0f, maxV, bark));
                builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 2.0f, maxV, bark));
                break;
            }
            case Z: {
                builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 16.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 16.0f, maxV, bark));
                builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 2.0f, maxV, bark));
                builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 16.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 16.0f, minV, bark));
                builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 2.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 2.0f, minV, bark));
                builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 16.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 16.0f, minV, bark));
                builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 2.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 2.0f, minV, bark));
                builder.m_119530_(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 16.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 16.0f, maxV, bark));
                builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 2.0f, maxV, bark));
            }
        }
        return builder.m_119533_();
    }

    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(icon);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.m_119530_(face, ModelUtils.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)icon, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        return builder.m_119533_();
    }

    public BakedModel bakeCoreSpikes(int radius, TextureAtlasSprite bark) {
        float minV = 8 - radius;
        float maxV = 8 + radius;
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(bark);
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 16.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 14.0f, minV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 14.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 2.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 0.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f - 0.002f), 0.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f - 0.002f), 2.0f, maxV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 16.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 14.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 14.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 16.0f, minV, bark));
        builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 2.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 0.0f, maxV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f + 0.002f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f + 0.002f), 2.0f, minV, bark));
        builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, bark));
        builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posFrom.x() / 16.0f, posFrom.y() / 16.0f - 0.002f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, bark));
        builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, bark));
        builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, this.v(posTo.x() / 16.0f, posTo.y() / 16.0f + 0.002f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, bark));
        builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, bark));
        builder.m_119530_(Direction.SOUTH, this.createQuad(this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.0625f), 16.0f, minV, bark));
        builder.m_119530_(Direction.NORTH, this.createQuad(this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.x() / 16.0f + 0.001f, posTo.y() / 16.0f, posFrom.z() / 16.0f + 0.0625f), 2.0f, minV, bark));
        builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 16.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 14.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 16.0f, minV, bark));
        builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 2.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posFrom.z() / 16.0f - 0.001f), 2.0f, minV, bark));
        builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 16.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 14.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f, posTo.z() / 16.0f + 0.001f), 2.0f, maxV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 16.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.002f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 2.0f, maxV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 16.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 16.0f, minV, bark));
        builder.m_119530_(Direction.DOWN, this.createQuad(this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 2.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posTo.x() / 16.0f + 0.002f, posFrom.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 2.0f, minV, bark));
        builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 16.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 16.0f, minV, bark));
        builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 2.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f - 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f + 0.0625f, posFrom.y() / 16.0f - 0.001f, posFrom.z() / 16.0f), 2.0f, minV, bark));
        builder.m_119530_(Direction.EAST, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 16.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.WEST, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 2.0f, maxV, bark));
        return builder.m_119533_();
    }

    public BakedModel bakeTopSleeveSpikes(TextureAtlasSprite bark) {
        float minV = 4.0f;
        float maxV = 12.0f;
        Vector3f posFrom = new Vector3f(4.0f, 16.0f, 4.0f);
        Vector3f posTo = new Vector3f(12.0f, 16.0f, 12.0f);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(bark);
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posTo, posTo, posFrom, 0.0f, 0.0625f, -0.002f), 16.0f, minV, this.v(posTo, posTo, posFrom, 0.0f, -0.0625f, -0.002f), 14.0f, minV, this.v(posFrom, posTo, posFrom, 0.0f, -0.0625f, -0.002f), 14.0f, maxV, this.v(posFrom, posTo, posFrom, 0.0f, 0.0625f, -0.002f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom, posTo, posTo, 0.0f, 0.0625f, 0.002f), 16.0f, maxV, this.v(posFrom, posTo, posTo, 0.0f, -0.0625f, 0.002f), 14.0f, maxV, this.v(posTo, posTo, posTo, 0.0f, -0.0625f, 0.002f), 14.0f, minV, this.v(posTo, posTo, posTo, 0.0f, 0.0625f, 0.002f), 16.0f, minV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom, posTo, posTo, 0.0f, 0.002f, -0.0625f), 14.0f, maxV, this.v(posFrom, posTo, posTo, 0.0f, 0.002f, 0.0625f), 16.0f, maxV, this.v(posTo, posTo, posTo, 0.0f, 0.002f, 0.0625f), 16.0f, minV, this.v(posTo, posTo, posTo, 0.0f, 0.002f, -0.0625f), 14.0f, minV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom, posTo, posFrom, 0.0f, 0.002f, -0.0625f), 0.0f, maxV, this.v(posFrom, posTo, posFrom, 0.0f, 0.002f, 0.0625f), 2.0f, maxV, this.v(posTo, posTo, posFrom, 0.0f, 0.002f, 0.0625f), 2.0f, minV, this.v(posTo, posTo, posFrom, 0.0f, 0.002f, -0.0625f), 0.0f, minV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 16.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posFrom.x() / 16.0f - 0.002f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f + 0.0625f, posTo.z() / 16.0f), 16.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f - 0.0625f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f - 0.0625f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f + 0.002f, posTo.y() / 16.0f + 0.0625f, posFrom.z() / 16.0f), 16.0f, minV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 16.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 14.0f, minV, this.v(posTo.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 14.0f, maxV, this.v(posTo.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 16.0f, maxV, bark));
        builder.m_119530_(Direction.UP, this.createQuad(this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 2.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posFrom.z() / 16.0f), 0.0f, minV, this.v(posFrom.x() / 16.0f - 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 0.0f, maxV, this.v(posFrom.x() / 16.0f + 0.0625f, posTo.y() / 16.0f + 0.001f, posTo.z() / 16.0f), 2.0f, maxV, bark));
        return builder.m_119533_();
    }

    public int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    private Vec3 v(Vector3f xVec, Vector3f yVec, Vector3f zVec, float xOffset, float yOffset, float zOffset) {
        return this.v(xVec.x() / 16.0f + xOffset, yVec.y() / 16.0f + yOffset, zVec.z() / 16.0f + zOffset);
    }

    private Vec3 v(float x, float y, float z) {
        return new Vec3((double)x, (double)y, (double)z);
    }

    private int getRadiusIndex(int radius) {
        for (int i = 0; i < this.radii.length; ++i) {
            if (radius != this.radii[i]) continue;
            return i;
        }
        return 0;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource random, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (side == null && state != null) {
            ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(12);
            int coreRadius = this.getRadius(state);
            int[] connections = new int[]{0, 0, 0, 0, 0, 0};
            Direction forceRingDir = null;
            ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
            if (connectionsData != null) {
                connections = connectionsData.getAllRadii();
                forceRingDir = connectionsData.getRingOnly();
            }
            int numConnections = 0;
            for (int i : connections) {
                numConnections += i != 0 ? 1 : 0;
            }
            if (numConnections == 0 && forceRingDir != null) {
                quadsList.addAll(this.rings[this.getRadiusIndex(coreRadius)].getQuads(state, forceRingDir, random, extraData, renderType));
            } else {
                Direction sourceDir;
                boolean extraUpSleeve = false;
                if (coreRadius == this.radii[0] && numConnections == 1 && ((Direction)state.m_61143_(CactusBranchBlock.ORIGIN)).m_122434_().m_122479_()) {
                    connections[1] = this.radii[0];
                    extraUpSleeve = true;
                }
                if ((sourceDir = this.getSourceDir(coreRadius, connections)) == null) {
                    sourceDir = Direction.DOWN;
                }
                int coreDir = this.resolveCoreDir(sourceDir);
                Direction coreRingDir = numConnections == 1 ? sourceDir.m_122424_() : null;
                for (Direction face : Direction.values()) {
                    if (coreRadius != connections[face.m_122411_()]) {
                        if (coreRingDir == null || coreRingDir != face) {
                            quadsList.addAll(this.cores[coreDir][this.getRadiusIndex(coreRadius)].getQuads(state, face, random, extraData, renderType));
                        } else {
                            quadsList.addAll(this.rings[this.getRadiusIndex(coreRadius)].getQuads(state, face, random, extraData, renderType));
                        }
                    }
                    for (Direction dir : Direction.values()) {
                        if (coreRadius <= connections[dir.m_122411_()]) continue;
                        for (BakedQuad quad : this.coreSpikes[this.getRadiusIndex(coreRadius)].getQuads(state, dir, random, extraData, renderType)) {
                            if (coreRadius <= connections[quad.m_111306_().m_122411_()]) continue;
                            quadsList.add(quad);
                        }
                    }
                    for (Direction connDir : Direction.values()) {
                        int idx = connDir.m_122411_();
                        int connRadius = connections[idx];
                        if (connRadius < this.radii[0] || (connDir != Direction.UP || connRadius != this.radii[0] || !extraUpSleeve) && face == connDir && connDir != Direction.DOWN) continue;
                        quadsList.addAll(this.sleeves[idx][this.getRadiusIndex(connRadius)].getQuads(state, face, random, extraData, renderType));
                    }
                }
                if (extraUpSleeve) {
                    quadsList.addAll(this.sleeveTopSpikes.getQuads(state, Direction.UP, random, extraData, renderType));
                }
            }
            return quadsList;
        }
        return Collections.emptyList();
    }

    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData extraData) {
        ModelConnections modelConnections;
        Block block = state.m_60734_();
        if (block instanceof BranchBlock) {
            BranchBlock branchBlock = (BranchBlock)block;
            modelConnections = new ModelConnections(branchBlock.getConnectionData(level, pos, state)).setFamily(branchBlock.getFamily());
        } else {
            modelConnections = new ModelConnections();
        }
        return modelConnections.toModelData(extraData);
    }

    @Nullable
    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : Direction.values()) {
            int connRadius = connections[dir.m_122411_()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(Direction dir) {
        return dir.m_122411_() >> 1;
    }

    protected int getRadius(BlockState blockState) {
        return ((CactusBranchBlock)blockState.m_60734_()).getRadius(blockState);
    }

    public boolean m_7541_() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon(@Nullable ModelData extraData) {
        return this.m_6160_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.barkTexture;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7547_() {
        return false;
    }
}

