/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.trees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PaperbarkFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(PaperbarkFamily::new);
    ItemStack paperStack = new ItemStack((ItemLike)Items.f_42516_);
    float barkRegrowChance = 0.01f;

    public PaperbarkFamily(ResourceLocation name) {
        super(name);
    }

    public ItemStack getPaperStack(Level world) {
        ItemStack stack = this.paperStack.m_41777_();
        stack.m_41764_(1 + world.f_46441_.m_188503_(3));
        return stack;
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch = new BasicBranchBlock(name, this.getProperties().m_60977_()){

            public void stripBranch(BlockState state, Level world, BlockPos pos, Player player, ItemStack heldItem) {
                Vec3 center = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
                Vec3 offsetDir = player.m_20182_().m_82546_(center).m_82541_().m_82542_(0.5, 0.5, 0.5);
                center = center.m_82549_(offsetDir);
                world.m_7967_((Entity)new ItemEntity(world, center.f_82479_, center.f_82480_, center.f_82481_, PaperbarkFamily.this.getPaperStack(world)));
                super.stripBranch(state, (LevelAccessor)world, pos, this.getRadius(state));
            }

            public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
                if (rand.m_188501_() < PaperbarkFamily.this.barkRegrowChance && this.isStrippedBranch()) {
                    int radius = TreeHelper.getRadius((BlockGetter)world, (BlockPos)pos);
                    int radiusDown = TreeHelper.isBranch((BlockState)world.m_8055_(pos.m_7495_())) ? TreeHelper.getRadius((BlockGetter)world, (BlockPos)pos.m_7495_()) : this.getMaxRadius();
                    this.getFamily().getBranch().ifPresent(branch -> branch.setRadius((LevelAccessor)world, pos, Math.min(radiusDown, radius + ((Boolean)DTConfigs.ENABLE_STRIP_RADIUS_REDUCTION.get() != false ? 1 : 0)), null));
                }
                super.m_213897_(state, world, pos, rand);
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }
}

