/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtaether.trees;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.systems.SeedSaplingRecipe;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class ModDependentSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = ModDependentSpecies.createDefaultType(ModDependentSpecies::new);
    Family original_family = this.getFamily();
    protected static String ONLY_IF_LOADED = "only_if_loaded";
    protected static String ONLY_IF_NOT_LOADED = "only_if_not_loaded";
    protected static String FAMILY = "family";
    protected static String FEATURES = "features";
    protected static String PRIMITIVE_SAPLINGS = "primitive_saplings";
    protected static String DROP_SEEDS = "drop_seeds";

    public ModDependentSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public void setLoadVariantProperties(JsonObject object) {
        String modId = object.get(ONLY_IF_LOADED).getAsString();
        if (ModList.get().isLoaded(modId) && (!object.has(ONLY_IF_NOT_LOADED) || !ModList.get().isLoaded(object.get(ONLY_IF_NOT_LOADED).getAsString())) && object.has(FAMILY)) {
            ResourceLocation familyRes = new ResourceLocation(object.get(FAMILY).getAsString());
            Family family = (Family)Family.REGISTRY.get(familyRes);
            this.setFamily(family);
            this.setSaplingName(this.getRegistryName().m_135815_() + "_sapling_" + modId);
        }
    }

    public void setReloadVariantProperties(JsonObject object) {
        String modId = object.get(ONLY_IF_LOADED).getAsString();
        if (!(!ModList.get().isLoaded(modId) || object.has(ONLY_IF_NOT_LOADED) && ModList.get().isLoaded(object.get(ONLY_IF_NOT_LOADED).getAsString()))) {
            JsonArray array;
            if (object.has(FEATURES)) {
                array = object.getAsJsonArray(FEATURES);
                array.forEach(elem -> {
                    if (elem.isJsonObject()) {
                        JsonDeserialisers.CONFIGURED_GEN_FEATURE.deserialiseIfValid(elem, res -> this.addGenFeature((GenFeatureConfiguration)res.get()));
                    } else if (elem.isJsonPrimitive()) {
                        JsonDeserialisers.GEN_FEATURE.deserialiseIfValid(elem, res -> this.addGenFeature((GenFeature)res.get()));
                    }
                });
            }
            if (object.has(PRIMITIVE_SAPLINGS)) {
                array = object.getAsJsonArray(PRIMITIVE_SAPLINGS);
                array.forEach(elem -> JsonDeserialisers.SEED_SAPLING_RECIPE.deserialiseIfValid(elem, res -> this.addPrimitiveSaplingRecipe((SeedSaplingRecipe)res.get())));
            }
            if (object.has(DROP_SEEDS)) {
                this.setDropSeeds(object.get(DROP_SEEDS).getAsBoolean());
            }
        }
    }
}

