/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class CoordUtils {
    public static int coordXor = 0;
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};
    private static final int[][] coordHashMap = new int[][]{{4111, 271, 3067}, {7933711, 6144389, 9538033}, {9973, 8287, 9721}, {7211, 5437, 9613}};

    public static boolean isSurroundedByLoadedChunks(Level level, BlockPos pos) {
        for (Surround surr : Surround.values()) {
            Vec3i dir = surr.getOffset();
            if (((ServerLevel)level).m_143340_(pos.m_121955_(dir))) continue;
            return false;
        }
        return true;
    }

    public static boolean canAccessStateSafely(BlockGetter level, BlockPos pos) {
        if (level instanceof LevelReader) {
            return ((LevelReader)level).m_7232_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
        }
        if (level instanceof PathNavigationRegion) {
            return !(((PathNavigationRegion)level).m_47185_(pos) instanceof EmptyLevelChunk);
        }
        return true;
    }

    @Nullable
    public static BlockState getStateSafe(BlockGetter level, BlockPos blockPos) {
        return CoordUtils.canAccessStateSafely(level, blockPos) ? level.m_8055_(blockPos) : null;
    }

    public static Direction getRandomDir(RandomSource rand) {
        return Direction.values()[2 + rand.m_188503_(4)];
    }

    public static BlockPos getRayTraceFruitPos(LevelAccessor level, Species species, BlockPos treePos, BlockPos branchPos, SafeChunkBounds safeBounds) {
        BlockPos hitPos;
        BlockHitResult result = CoordUtils.branchRayTrace(level, species, treePos, branchPos, 45.0f, 60.0f, 4 + level.m_213780_().m_188503_(3), safeBounds);
        if (result != null && (hitPos = BlockPos.m_274446_((Position)result.m_82450_())) != BlockPos.f_121853_) {
            do {
                hitPos = hitPos.m_7495_();
            } while (species.getFamily().isCompatibleGenericLeaves(species, level.m_8055_(hitPos), level, hitPos));
            if (level.m_46859_(hitPos)) {
                return hitPos;
            }
        }
        return BlockPos.f_121853_;
    }

    @Nullable
    public static BlockHitResult branchRayTrace(LevelAccessor level, Species species, BlockPos treePos, BlockPos branchPos, float spreadHor, float spreadVer, float distance, SafeChunkBounds safeBounds) {
        treePos = new BlockPos(treePos.m_123341_(), branchPos.m_123342_(), treePos.m_123343_());
        Vec3 vOut = new Vec3((double)(branchPos.m_123341_() - treePos.m_123341_()), 0.0, (double)(branchPos.m_123343_() - treePos.m_123343_()));
        if (vOut.equals((Object)Vec3.f_82478_)) {
            vOut = new Vec3(1.0, 0.0, 0.0);
            spreadHor = 180.0f;
        }
        float deltaYaw = level.m_213780_().m_188501_() * spreadHor * 2.0f - spreadHor;
        float deltaPitch = level.m_213780_().m_188501_() * -spreadVer;
        vOut = vOut.m_82541_().m_82520_(0.0, Math.tan(Math.toRadians(deltaPitch)), 0.0).m_82541_().m_82524_((float)Math.toRadians(deltaYaw)).m_82490_((double)distance);
        Vec3 branchVec = new Vec3((double)branchPos.m_123341_(), (double)branchPos.m_123342_(), (double)branchPos.m_123343_()).m_82520_(0.5, 0.5, 0.5);
        Vec3 vantageVec = branchVec.m_82549_(vOut);
        BlockPos vantagePos = BlockPos.m_274446_((Position)vantageVec);
        if (!safeBounds.inBounds(vantagePos, false) || level.m_46859_(vantagePos)) {
            BlockHitResult result = CoordUtils.rayTraceBlocks(level, new CustomRayTraceContext(vantageVec, branchVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE), safeBounds);
            BlockPos hitPos = BlockPos.m_274446_((Position)result.m_82450_());
            if (result.m_6662_() == HitResult.Type.BLOCK && !hitPos.equals((Object)BlockPos.f_121853_) && species.getFamily().isCompatibleGenericLeaves(species, level.m_8055_(hitPos), level, hitPos)) {
                return result;
            }
        }
        return null;
    }

    public static BlockHitResult rayTraceBlocks(LevelAccessor level, CustomRayTraceContext context, SafeChunkBounds safeBounds) {
        return CoordUtils.getRayTraceVector(context, (fromContext, blockPos) -> {
            BlockState blockstate = safeBounds.inBounds((BlockPos)blockPos, false) ? level.m_8055_(blockPos) : Blocks.f_50016_.m_49966_();
            FluidState fluidState = safeBounds.inBounds((BlockPos)blockPos, false) ? level.m_6425_(blockPos) : Fluids.f_76191_.m_76145_();
            Vec3 startVec = fromContext.getStartVector();
            Vec3 endVec = fromContext.getEndVector();
            VoxelShape voxelshape = safeBounds.inBounds((BlockPos)blockPos, false) ? fromContext.getBlockShape(blockstate, (BlockGetter)level, (BlockPos)blockPos) : Shapes.m_83040_();
            BlockHitResult blockraytraceresult = level.m_45558_(startVec, endVec, blockPos, voxelshape, blockstate);
            VoxelShape voxelshape1 = safeBounds.inBounds((BlockPos)blockPos, false) ? fromContext.getFluidShape(fluidState, (BlockGetter)level, (BlockPos)blockPos) : Shapes.m_83040_();
            BlockHitResult blockraytraceresult1 = voxelshape1.m_83220_(startVec, endVec, blockPos);
            double d0 = blockraytraceresult == null ? Double.MAX_VALUE : fromContext.getStartVector().m_82557_(blockraytraceresult.m_82450_());
            double d1 = blockraytraceresult1 == null ? Double.MAX_VALUE : fromContext.getStartVector().m_82557_(blockraytraceresult1.m_82450_());
            return d0 <= d1 ? blockraytraceresult : blockraytraceresult1;
        }, context1 -> {
            Vec3 vec3d = context1.getStartVector().m_82546_(context1.getEndVector());
            return BlockHitResult.m_82426_((Vec3)context1.getEndVector(), (Direction)Direction.m_122366_((double)vec3d.f_82479_, (double)vec3d.f_82480_, (double)vec3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)context1.getEndVector()));
        });
    }

    private static <T> T getRayTraceVector(CustomRayTraceContext context, BiFunction<CustomRayTraceContext, BlockPos, T> biFunction, Function<CustomRayTraceContext, T> function) {
        int k;
        int j;
        Vec3 endVec;
        Vec3 startVec = context.getStartVector();
        if (startVec.equals((Object)(endVec = context.getEndVector()))) {
            return function.apply(context);
        }
        double vantX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double vantY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double vantZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double lookX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double lookY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double lookZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int i = Mth.m_14107_((double)lookX);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(i, j = Mth.m_14107_((double)lookY), k = Mth.m_14107_((double)lookZ));
        T t = biFunction.apply(context, (BlockPos)blockpos$mutableblockpos);
        if (t != null) {
            return t;
        }
        double d6 = vantX - lookX;
        double d7 = vantY - lookY;
        double d8 = vantZ - lookZ;
        int l = Mth.m_14205_((double)d6);
        int i1 = Mth.m_14205_((double)d7);
        int j1 = Mth.m_14205_((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.m_14185_((double)lookX) : Mth.m_14185_((double)lookX));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.m_14185_((double)lookY) : Mth.m_14185_((double)lookY));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.m_14185_((double)lookZ) : Mth.m_14185_((double)lookZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = biFunction.apply(context, (BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k))) == null) continue;
            return t1;
        }
        return function.apply(context);
    }

    public static BlockPos findWorldSurface(LevelAccessor level, BlockPos startPos, boolean worldGen) {
        return CoordUtils.findWorldSurface(level, startPos, worldGen ? Heightmap.Types.WORLD_SURFACE_WG : Heightmap.Types.WORLD_SURFACE);
    }

    public static BlockPos findWorldSurface(LevelAccessor level, BlockPos startPos, Heightmap.Types heightmap) {
        return new BlockPos(startPos.m_123341_(), level.m_6924_(heightmap, startPos.m_123341_(), startPos.m_123343_()) - 1, startPos.m_123343_());
    }

    public static boolean inRange(BlockPos pos, int minY, int maxY) {
        return pos.m_123342_() >= minY && pos.m_123342_() <= maxY;
    }

    public static int coordHashCode(BlockPos pos, int a, int b, int c) {
        int hash = (pos.m_123341_() * a ^ pos.m_123342_() * b ^ pos.m_123343_() * c) >> 1;
        return (hash ^ coordXor) & 0xFFFF;
    }

    public static int coordHashCode(BlockPos pos, int readyMade) {
        int[] factors = coordHashMap[readyMade & 3];
        return CoordUtils.coordHashCode(pos, factors[0], factors[1], factors[2]);
    }

    public static Iterable<BlockPos> goHorSides(BlockPos pos) {
        return CoordUtils.goHorSides(pos, null);
    }

    public static Iterable<BlockPos> goHorSides(final BlockPos pos, final @Nullable Direction ignore) {
        return new Iterable<BlockPos>(){

            @Override
            @Nonnull
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int currentDir = 0;

                    protected BlockPos computeNext() {
                        while (this.currentDir < HORIZONTALS.length) {
                            Direction face;
                            if ((face = HORIZONTALS[this.currentDir++]) == ignore) continue;
                            return pos.m_121945_(face);
                        }
                        return (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    public static enum Surround implements StringRepresentable
    {
        N("n", Direction.NORTH),
        NW("nw", Direction.NORTH, Direction.WEST),
        W("w", Direction.WEST),
        SW("sw", Direction.SOUTH, Direction.WEST),
        S("s", Direction.SOUTH),
        SE("se", Direction.SOUTH, Direction.EAST),
        E("e", Direction.EAST),
        NE("ne", Direction.NORTH, Direction.EAST);

        private final String name;
        private final Vec3i offset;

        private Surround(String name, Direction ... dirs) {
            this.name = name;
            BlockPos pos = BlockPos.f_121853_;
            for (Direction d : dirs) {
                pos = pos.m_121955_(d.m_122436_());
            }
            this.offset = pos;
        }

        public String m_7912_() {
            return this.name;
        }

        public Vec3i getOffset() {
            return this.offset;
        }

        public BlockPos getOffsetPos() {
            return new BlockPos(this.offset);
        }

        public Surround getOpposite() {
            return Surround.values()[this.ordinal() + 4 & 7];
        }
    }

    private static class CustomRayTraceContext {
        private final Vec3 startVec;
        private final Vec3 endVec;
        private final ClipContext.Block blockMode;
        private final ClipContext.Fluid fluidMode;

        public CustomRayTraceContext(Vec3 startVecIn, Vec3 endVecIn, ClipContext.Block blockModeIn, ClipContext.Fluid fluidModeIn) {
            this.startVec = startVecIn;
            this.endVec = endVecIn;
            this.blockMode = blockModeIn;
            this.fluidMode = fluidModeIn;
        }

        public Vec3 getEndVector() {
            return this.endVec;
        }

        public Vec3 getStartVector() {
            return this.startVec;
        }

        public VoxelShape getBlockShape(BlockState state, BlockGetter level, BlockPos pos) {
            return this.blockMode.m_7544_(state, level, pos, CollisionContext.m_82749_());
        }

        public VoxelShape getFluidShape(FluidState state, BlockGetter level, BlockPos pos) {
            return this.fluidMode.m_45731_(state) ? state.m_76183_(level, pos) : Shapes.m_83040_();
        }
    }
}

