/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.tree.species.MangroveSpecies;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class MangroveRootsLogic
extends GrowthLogicKit {
    public MangroveRootsLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.m_122424_();
        Direction defaultDir = context.signal().defaultDir;
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            if (dir.m_122434_().m_122479_()) {
                probMap[dir.m_122411_()] = 1;
            }
            if (dir.equals((Object)defaultDir)) {
                probMap[dir.m_122411_()] = context.species().getUpProbability();
            }
            if (dir.equals((Object)defaultDir.m_122424_())) {
                probMap[dir.m_122411_()] = 0;
            }
            BlockPos deltaPos = context.pos().m_121945_(dir);
            BlockState deltaBlockState = context.level().m_8055_(deltaPos);
            int n = dir.m_122411_();
            probMap[n] = probMap[n] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (BlockGetter)context.level(), deltaPos, context.branch());
        }
        if (context.signal().isInTrunk()) {
            probMap[defaultDir.ordinal()] = 0;
        }
        probMap[defaultDir.m_122424_().ordinal()] = 0;
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    @Override
    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        int[] probMap = configuration.populateDirectionProbabilityMap(new DirectionManipulationContext(context.level(), context.pos(), context.species(), context.branch(), context.signal(), context.branch().getRadius(context.level().m_8055_(context.pos())), new int[6]));
        int choice = MathHelper.selectRandomFromDistribution(context.signal().rand, probMap);
        return Direction.values()[choice != -1 ? choice : 1];
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return 0;
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        Species species = context.species();
        if (species instanceof MangroveSpecies) {
            MangroveSpecies mangroveSpecies = (MangroveSpecies)species;
            return mangroveSpecies.getRootSignalEnergy();
        }
        return context.species().getSignalEnergy();
    }
}

