/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.leaves;

import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.LeavesPropertiesLangGenerator;
import com.ferreusveritas.dynamictrees.api.data.LeavesStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.client.BlockColorMultipliers;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.tree.Resettable;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.LootTableSupplier;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class LeavesProperties
extends RegistryEntry<LeavesProperties>
implements Resettable<LeavesProperties> {
    public static final Codec<LeavesProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName)).apply((Applicative)instance, LeavesProperties::new));
    public static final LeavesProperties NULL = ((LeavesProperties)new LeavesProperties(){

        @Override
        public LeavesProperties setFamily(Family family) {
            return this;
        }

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public BlockState getPrimitiveLeaves() {
            return Blocks.f_50016_.m_49966_();
        }

        @Override
        public ItemStack getPrimitiveLeavesItemStack() {
            return ItemStack.f_41583_;
        }

        @Override
        public LeavesProperties setDynamicLeavesState(BlockState state) {
            return this;
        }

        @Override
        public BlockState getDynamicLeavesState() {
            return Blocks.f_50016_.m_49966_();
        }

        @Override
        public BlockState getDynamicLeavesState(int hydro) {
            return Blocks.f_50016_.m_49966_();
        }

        @Override
        public CellKit getCellKit() {
            return CellKit.NULL_CELL_KIT;
        }

        @Override
        public int getFlammability() {
            return 0;
        }

        @Override
        public int getFireSpreadSpeed() {
            return 0;
        }

        @Override
        public int getSmotherLeavesMax() {
            return 0;
        }

        @Override
        public int getLightRequirement() {
            return 15;
        }

        @Override
        public boolean updateTick(LevelAccessor level, BlockPos pos, BlockState state, RandomSource rand) {
            return false;
        }
    }.setRegistryName(DTTrees.NULL)).setBlockRegistryName(DTTrees.NULL);
    public static final TypedRegistry<LeavesProperties> REGISTRY = new TypedRegistry<LeavesProperties>(LeavesProperties.class, NULL, new TypedRegistry.EntryType<LeavesProperties>(CODEC));
    protected static final int maxHydro = 7;
    protected BlockState primitiveLeaves;
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected CellKit cellKit;
    protected Family family;
    protected BlockState[] dynamicLeavesBlockHydroStates = new BlockState[8];
    protected int flammability = 60;
    protected int fireSpreadSpeed = 30;
    protected int smotherLeavesMax = 4;
    protected int lightRequirement = 13;
    protected AgeingConfiguration ageingConfiguration = AgeingConfiguration.ALWAYS;
    protected boolean connectAnyRadius = false;
    protected boolean requiresShears = true;
    protected boolean hasTickParticles = false;
    protected float[] seedDropChances = new float[]{0.015625f, 0.03125f, 0.046875f, 0.0625f};
    private final LootTableSupplier blockLootTableSupplier;
    private final LootTableSupplier lootTableSupplier;
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    protected HashMap<String, String> langOverrides = new HashMap();
    public static final String LEAVES = "leaves";
    private ResourceLocation blockRegistryName;
    private boolean canGrowOnGround = false;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, LeavesProperties>> stateGenerator = MutableLazyValue.supplied(LeavesStateGenerator::new);
    protected final MutableLazyValue<Generator<DTLangProvider, LeavesProperties>> langGenerator = MutableLazyValue.supplied(LeavesPropertiesLangGenerator::new);
    protected Integer colorNumber;
    protected String colorString;
    @OnlyIn(value=Dist.CLIENT)
    private BlockColor colorMultiplier;

    private LeavesProperties() {
        this.blockLootTableSupplier = new LootTableSupplier("null/", DTTrees.NULL);
        this.lootTableSupplier = new LootTableSupplier("null/", DTTrees.NULL);
    }

    public LeavesProperties(ResourceLocation registryName) {
        this(null, registryName);
    }

    public LeavesProperties(@Nullable BlockState primitiveLeaves, ResourceLocation registryName) {
        this(primitiveLeaves, CellKits.DECIDUOUS, registryName);
    }

    public LeavesProperties(@Nullable BlockState primitiveLeaves, CellKit cellKit, ResourceLocation registryName) {
        this.family = Family.NULL_FAMILY;
        this.primitiveLeaves = primitiveLeaves != null ? primitiveLeaves : BlockStates.AIR;
        this.cellKit = cellKit;
        this.setRegistryName(registryName);
        this.blockRegistryName = ResourceLocationUtils.suffix(registryName, this.getBlockRegistryNameSuffix());
        this.blockLootTableSupplier = new LootTableSupplier("blocks/", this.blockRegistryName);
        this.lootTableSupplier = new LootTableSupplier("trees/leaves/", registryName);
    }

    public void setSeedDropChances(float[] seedDropChances) {
        this.seedDropChances = seedDropChances;
    }

    public void setSeedDropChances(Collection<Float> seedDropChances) {
        this.seedDropChances = new float[seedDropChances.size()];
        Iterator<Float> iterator = seedDropChances.iterator();
        for (int i = 0; i < seedDropChances.size(); ++i) {
            this.seedDropChances[i] = iterator.next().floatValue();
        }
    }

    public ResourceLocation getBlockLootTableName() {
        return this.blockLootTableSupplier.getName();
    }

    public LootTable getBlockLootTable(LootDataManager lootTables, Species species) {
        return this.blockLootTableSupplier.get(lootTables, species);
    }

    public boolean shouldGenerateBlockDrops() {
        return this.shouldGenerateDrops();
    }

    public LootTable.Builder createBlockDrops() {
        if (this.primitiveLeaves != null && this.getPrimitiveLeavesBlock().isPresent()) {
            return DTLootTableProvider.BlockLoot.createLeavesBlockDrops(this.primitiveLeaves.m_60734_(), this.seedDropChances, this.getFamily().getStick(1).m_41720_());
        }
        return DTLootTableProvider.BlockLoot.createLeavesDrops(this.seedDropChances, LootContextParamSets.f_81421_);
    }

    public ResourceLocation getLootTableName() {
        return this.lootTableSupplier.getName();
    }

    public LootTable getLootTable(LootDataManager lootTables, Species species) {
        return this.lootTableSupplier.get(lootTables, species);
    }

    public boolean shouldGenerateDrops() {
        return this.getPrimitiveLeavesBlock().isPresent();
    }

    public LootTable.Builder createDrops() {
        return DTLootTableProvider.BlockLoot.createLeavesDrops(this.seedDropChances, DTLootParameterSets.LEAVES);
    }

    public List<ItemStack> getDrops(Level level, BlockPos pos, ItemStack tool, Species species) {
        if (level.f_46443_) {
            return Collections.emptyList();
        }
        return this.getLootTable(level.m_7654_().m_278653_(), species).m_287195_(this.createLootParams(level, pos, tool, species));
    }

    private LootParams createLootParams(Level level, BlockPos pos, ItemStack tool, Species species) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287286_(DTLootContextParams.SPECIES, (Object)species).m_287286_(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(species.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), pos))).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287235_(DTLootParameterSets.LEAVES);
    }

    public BlockState getPrimitiveLeaves() {
        return this.primitiveLeaves;
    }

    public Optional<Block> getPrimitiveLeavesBlock() {
        return Optionals.ofBlock(this.primitiveLeaves == null ? null : this.primitiveLeaves.m_60734_());
    }

    public void setPrimitiveLeaves(Block primitiveLeaves) {
        if (this.primitiveLeaves == null || primitiveLeaves != this.primitiveLeaves.m_60734_()) {
            this.primitiveLeaves = primitiveLeaves.m_49966_();
        }
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public ItemStack getPrimitiveLeavesItemStack() {
        return new ItemStack((ItemLike)Item.f_41373_.get(this.getPrimitiveLeaves().m_60734_()));
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public void setLangOverrides(Map<String, String> modelOverrides) {
        this.langOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public Optional<String> getLangOverride(String key) {
        return Optional.ofNullable(this.langOverrides.getOrDefault(key, null));
    }

    public ResourceLocation getBlockRegistryName() {
        return this.blockRegistryName;
    }

    public LeavesProperties setBlockRegistryName(ResourceLocation blockRegistryName) {
        this.blockRegistryName = blockRegistryName;
        return this;
    }

    protected String getBlockRegistryNameSuffix() {
        return "_leaves";
    }

    public Optional<DynamicLeavesBlock> getDynamicLeavesBlock() {
        Block block = this.getDynamicLeavesState().m_60734_();
        return Optional.ofNullable(block instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)block : null);
    }

    protected DynamicLeavesBlock createDynamicLeaves(BlockBehaviour.Properties properties) {
        return new DynamicLeavesBlock(this, properties);
    }

    public void generateDynamicLeaves(BlockBehaviour.Properties properties) {
        RegistryHandler.addBlock(this.blockRegistryName, () -> this.createDynamicLeaves(properties));
    }

    public LeavesProperties setDynamicLeavesState(BlockState state) {
        this.dynamicLeavesBlockHydroStates[0] = Blocks.f_50016_.m_49966_();
        for (int i = 1; i <= 7; ++i) {
            this.dynamicLeavesBlockHydroStates[i] = (BlockState)state.m_61124_((Property)DynamicLeavesBlock.f_54418_, (Comparable)Integer.valueOf(i));
        }
        return this;
    }

    public BlockState getDynamicLeavesState() {
        return this.getDynamicLeavesState(this.getCellKit().getDefaultHydration());
    }

    public BlockState getDynamicLeavesState(int hydro) {
        return Optional.ofNullable(this.dynamicLeavesBlockHydroStates[Mth.m_14045_((int)hydro, (int)0, (int)7)]).orElse(Blocks.f_50016_.m_49966_());
    }

    public Family getFamily() {
        return this.family;
    }

    public LeavesProperties setFamily(Family family) {
        this.family = family;
        if (family.isFireProof()) {
            this.flammability = 0;
            this.fireSpreadSpeed = 0;
        }
        return this;
    }

    public int getFlammability() {
        return this.flammability;
    }

    public void setFlammability(int flammability) {
        this.flammability = flammability;
    }

    public int getFireSpreadSpeed() {
        return this.fireSpreadSpeed;
    }

    public void setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
    }

    public int getSmotherLeavesMax() {
        return this.smotherLeavesMax;
    }

    public void setSmotherLeavesMax(int smotherLeavesMax) {
        this.smotherLeavesMax = smotherLeavesMax;
    }

    public int getLightRequirement() {
        return this.lightRequirement;
    }

    public void setLightRequirement(int lightRequirement) {
        this.lightRequirement = lightRequirement;
    }

    public boolean shouldAge(boolean worldGen, BlockState state) {
        return this.ageingConfiguration.shouldAge(worldGen);
    }

    @Deprecated
    public void setDoesAge(String doesAge) {
        try {
            this.ageingConfiguration = AgeingConfiguration.valueOf(doesAge.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid ageing configuration \"" + doesAge + "\".");
        }
    }

    public void setAgeingConfiguration(AgeingConfiguration doesAge) {
        this.ageingConfiguration = doesAge;
    }

    public void setCanGrowOnGround(boolean canGrowOnGround) {
        this.canGrowOnGround = canGrowOnGround;
    }

    public boolean canGrowOnGround() {
        return this.canGrowOnGround;
    }

    public CellKit getCellKit() {
        return this.cellKit;
    }

    public void setCellKit(CellKit cellKit) {
        this.cellKit = cellKit;
    }

    public boolean isConnectAnyRadius() {
        return this.connectAnyRadius;
    }

    public void setConnectAnyRadius(boolean connectAnyRadius) {
        this.connectAnyRadius = connectAnyRadius;
    }

    public MapColor getDefaultMapColor() {
        return MapColor.f_283915_;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_278183_().m_278166_(PushReaction.DESTROY).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((s, r, p, e) -> e == EntityType.f_20505_ || e == EntityType.f_20508_).m_60960_((s, r, p) -> false).m_60971_((s, r, p) -> false).m_280606_();
    }

    public boolean updateTick(LevelAccessor level, BlockPos pos, BlockState state, RandomSource rand) {
        return this.shouldAge(false, state);
    }

    public int getRadiusForConnection(BlockState state, BlockGetter blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        int twigRadius = from.getFamily().getPrimaryThickness();
        if (!from.connectToLeaves(blockAccess, pos, side, fromRadius)) {
            return 0;
        }
        return (fromRadius == twigRadius || this.connectAnyRadius) && from.getFamily().isCompatibleDynamicLeaves(from.getFamily().getCommonSpecies(), blockAccess.m_8055_(pos), blockAccess, pos) ? twigRadius : 0;
    }

    public boolean doRequireShears() {
        return this.requiresShears;
    }

    public void setRequiresShears(boolean requiresShears) {
        this.requiresShears = requiresShears;
    }

    public void setHasTickParticles(boolean hasTickParticles) {
        this.hasTickParticles = hasTickParticles;
    }

    public List<TagKey<Block>> defaultLeavesTags() {
        return Collections.singletonList(DTBlockTags.LEAVES);
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.stateGenerator.get().generate(provider, this);
    }

    @Override
    public void generateLangData(DTLangProvider provider) {
    }

    public boolean isCompatibleLeaves(LeavesProperties leaves) {
        return this.getFamily() == leaves.getFamily();
    }

    protected int maxLeavesRecursion() {
        return 256;
    }

    public void setColorNumber(Integer colorNumber) {
        this.colorNumber = colorNumber;
    }

    public void setColorString(String colorString) {
        this.colorString = colorString;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int treeFallColorMultiplier(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        return this.foliageColorMultiplier(state, level, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int foliageColorMultiplier(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        if (this.colorMultiplier == null) {
            return 0xFF00FF;
        }
        return this.colorMultiplier.m_92566_(state, level, pos, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processColor() {
        int color = -1;
        if (this.colorNumber != null) {
            color = this.colorNumber;
        } else if (this.colorString != null) {
            String code = this.colorString;
            if (code.startsWith("@")) {
                if ("biome".equals(code = code.substring(1))) {
                    this.colorMultiplier = (state, level, pos, t) -> ((Biome)((LevelAccessor)level).m_204166_(pos).m_203334_()).m_47542_();
                    return;
                }
                BlockColor blockColor = BlockColorMultipliers.find(code);
                if (blockColor != null) {
                    this.colorMultiplier = blockColor;
                    return;
                }
                LogManager.getLogger().error("ColorMultiplier resource '{}' could not be found.", (Object)code);
            } else {
                color = Color.decode(code).getRGB();
            }
        }
        int c = color;
        this.colorMultiplier = (s, w, p, t) -> c == -1 ? Minecraft.m_91087_().m_91298_().m_92577_(this.getPrimitiveLeaves(), w, p, 0) : c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void postInitClient() {
        REGISTRY.getAll().forEach(LeavesProperties::processColor);
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"primitiveLeaves", (Object)this.primitiveLeaves), Pair.of((Object)"cellKit", (Object)this.cellKit), Pair.of((Object)"smotherLeavesMax", (Object)this.smotherLeavesMax), Pair.of((Object)"lightRequirement", (Object)this.lightRequirement), Pair.of((Object)"fireSpreadSpeed", (Object)this.fireSpreadSpeed), Pair.of((Object)"flammability", (Object)this.flammability), Pair.of((Object)"connectAnyRadius", (Object)this.connectAnyRadius));
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getDynamicLeavesBlock().ifPresent(leaves -> this.defaultLeavesTags().forEach(tag -> {
            if (this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_(leaves));
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_(leaves);
            }
        }));
    }

    public static enum AgeingConfiguration {
        ALWAYS(true, true),
        WORLDGEN_ONLY(true, false),
        GROWTH_ONLY(false, true),
        NEVER(false, false);

        private final boolean ageDuringWorldGen;
        private final boolean ageDuringGrowth;

        private AgeingConfiguration(boolean ageDuringWorldGen, boolean ageDuringGrowth) {
            this.ageDuringWorldGen = ageDuringWorldGen;
            this.ageDuringGrowth = ageDuringGrowth;
        }

        public boolean shouldAge(boolean worldGen) {
            if (worldGen) {
                return this.ageDuringWorldGen;
            }
            return this.ageDuringGrowth;
        }
    }
}

