/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.PodBlock;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OffsetablePodBlock
extends PodBlock {
    public OffsetablePodBlock(BlockBehaviour.Properties properties, Pod pod) {
        super(properties, pod);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.pod != null) {
            builder.m_61104_(new Property[]{this.pod.getOffsetProperty()});
        }
        super.m_7926_(builder);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        int rad = TreeHelper.getRadius((BlockGetter)context.m_43725_(), context.m_8083_());
        if (this.pod.isValidRadius(rad)) {
            return (BlockState)state.m_61124_((Property)this.pod.getOffsetProperty(), (Comparable)Integer.valueOf(rad));
        }
        return null;
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        int newOffset;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        int currentOffset = (Integer)state.m_61143_((Property)this.pod.getOffsetProperty());
        if (currentOffset != (newOffset = TreeHelper.getRadius((BlockGetter)level, pos.m_121955_(direction.m_122436_()))) && this.pod.isValidRadius(newOffset)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.pod.getOffsetProperty(), (Comparable)Integer.valueOf(newOffset)), 2);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        VoxelShape shape = super.m_5940_(state, level, pos, context);
        float mult = 0.0625f * (float)(8 - (Integer)state.m_61143_((Property)this.pod.getOffsetProperty()));
        return shape.m_83216_((double)((float)dir.m_122429_() * mult), (double)((float)dir.m_122430_() * mult), (double)((float)dir.m_122431_() * mult));
    }
}

