/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.api.GatherDataHelper;
import com.ferreusveritas.dynamictrees.api.data.DTExtraLangGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.command.DTArgumentTypes;
import com.ferreusveritas.dynamictrees.compat.CompatHandler;
import com.ferreusveritas.dynamictrees.data.provider.DTDatapackBuiltinEntriesProvider;
import com.ferreusveritas.dynamictrees.event.handler.EventHandlers;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.loot.DTLoot;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommonSetup;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dynamictrees")
public final class DynamicTrees {
    public static final String MOD_ID = "dynamictrees";
    public static final String NAME = "Dynamic Trees";
    public static final String MINECRAFT = "minecraft";
    public static final String FORGE = "forge";
    public static final String SERENE_SEASONS = "sereneseasons";
    public static final String BETTER_WEATHER = "betterweather";
    public static final String FAST_LEAF_DECAY = "fastleafdecay";
    public static final String PASSABLE_FOLIAGE = "passablefoliage";

    public DynamicTrees() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext loadingContext = ModLoadingContext.get();
        loadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DTConfigs.SERVER_CONFIG);
        loadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DTConfigs.COMMON_CONFIG);
        loadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DTConfigs.CLIENT_CONFIG);
        RegistryHandler.setup(MOD_ID);
        DTRegistries.setup();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(CommonSetup::onCommonSetup);
        EventHandlers.registerCommon();
        CompatHandler.registerBuiltInSeasonManagers();
        DTArgumentTypes.ARGUMENT_TYPES.register(modEventBus);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DTClient.setup();
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        DTLoot.load();
        DynamicTreeFeature.setup();
        RegistryHandler.REGISTRY.clear();
        DTRegistries.DENDRO_POTION.get().registerRecipes();
        Resources.MANAGER.setup();
    }

    private void gatherData(GatherDataEvent event) {
        Resources.MANAGER.gatherData();
        GatherDataHelper.addLangGenerator(MOD_ID, new DTExtraLangGenerator());
        GatherDataHelper.gatherAllData(MOD_ID, event, SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY);
        DataGenerator dataGen = event.getGenerator();
        dataGen.addProvider(event.includeServer(), (DataProvider)new DTDatapackBuiltinEntriesProvider(dataGen.getPackOutput(), event.getLookupProvider(), Set.of(MOD_ID, MINECRAFT)));
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static enum SwampOakWaterState {
        ROOTED,
        SUNK,
        DISABLED;

    }

    public static enum DestroyMode {
        IGNORE,
        SLOPPY,
        SET_RADIUS,
        HARVEST,
        ROT,
        OVERFLOW;

    }

    public static enum AxeDamage {
        VANILLA,
        THICKNESS,
        VOLUME;

    }
}

