/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.densetrees.data;

import com.mrbysco.densetrees.data.assets.DenseBlockStateProvider;
import com.mrbysco.densetrees.data.assets.DenseItemModelProvider;
import com.mrbysco.densetrees.data.assets.DenseLanguageProvider;
import com.mrbysco.densetrees.data.data.DenseBiomeModifiers;
import com.mrbysco.densetrees.data.data.DenseBlockTagProvider;
import com.mrbysco.densetrees.data.data.DenseItemTagProvider;
import com.mrbysco.densetrees.data.data.DenseLootProvider;
import com.mrbysco.densetrees.data.data.DenseRecipeProvider;
import com.mrbysco.densetrees.world.DensePlacedFeatures;
import com.mrbysco.densetrees.world.DenseTreeFeatures;
import com.mrbysco.densetrees.world.DenseTreePlacements;
import com.mrbysco.densetrees.world.DenseVegetationFeatures;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DenseDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(DenseDatagen::getProvider);
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new DenseRecipeProvider(packOutput));
            generator.addProvider(true, (DataProvider)new DenseLootProvider(packOutput));
            DenseBlockTagProvider provider = new DenseBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)provider);
            generator.addProvider(true, (DataProvider)new DenseItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)provider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, Set.of("densetrees")));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new DenseLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new DenseBlockStateProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new DenseItemModelProvider(packOutput, helper));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256911_, context -> {
            DenseVegetationFeatures.bootstrap(context);
            DenseTreeFeatures.bootstrap(context);
        });
        registryBuilder.m_254916_(Registries.f_256988_, context -> {
            DensePlacedFeatures.bootstrap((BootstapContext<PlacedFeature>)context);
            DenseTreePlacements.bootstrap((BootstapContext<PlacedFeature>)context);
        });
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, DenseBiomeModifiers::bootstrap);
        registryBuilder.m_254916_(Registries.f_256952_, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

