/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.client.newctm.ConnectionCheck;
import team.chisel.ctm.client.newctm.LocalDirection;
import team.chisel.ctm.client.util.DirectionHelper;

@ParametersAreNonnullByDefault
public enum Dir implements LocalDirection,
StringRepresentable
{
    TOP(Direction.UP),
    TOP_RIGHT(Direction.UP, Direction.EAST),
    RIGHT(Direction.EAST),
    BOTTOM_RIGHT(Direction.DOWN, Direction.EAST),
    BOTTOM(Direction.DOWN),
    BOTTOM_LEFT(Direction.DOWN, Direction.WEST),
    LEFT(Direction.WEST),
    TOP_LEFT(Direction.UP, Direction.WEST);

    public static final Dir[] VALUES;
    private static final Direction NORMAL;
    @NotNull
    private final Direction[] dirs;
    @NotNull
    private final BlockPos[] offsets = new BlockPos[6];

    private Dir(Direction ... dirs) {
        this.dirs = dirs;
    }

    private void buildCaches() {
        for (Direction normal : Direction.values()) {
            BlockPos ret;
            Direction[] normalized;
            if (normal == NORMAL) {
                normalized = this.dirs;
            } else if (normal == NORMAL.m_122424_()) {
                ret = new Direction[this.dirs.length];
                for (int i = 0; i < ((Direction[])ret).length; ++i) {
                    ret[i] = this.dirs[i].m_122430_() != 0 ? this.dirs[i] : this.dirs[i].m_122424_();
                }
                normalized = ret;
            } else {
                Direction axis = normal.m_122430_() == 0 ? (normal == NORMAL.m_122427_() ? Direction.UP : Direction.DOWN) : (normal == Direction.UP ? NORMAL.m_122428_() : NORMAL.m_122427_());
                Direction[] ret2 = new Direction[this.dirs.length];
                for (int i = 0; i < ret2.length; ++i) {
                    ret2[i] = this.rotate(this.dirs[i], axis);
                }
                normalized = ret2;
            }
            ret = BlockPos.f_121853_;
            for (Direction dir : normalized) {
                ret = ret.m_121945_(dir);
            }
            this.offsets[normal.ordinal()] = ret;
        }
    }

    @Override
    public boolean isConnected(ConnectionCheck ctm, BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        return ctm.isConnected(world, pos, state, this.applyConnection(pos, side), side);
    }

    @Override
    public boolean isConnected(ConnectionCheck ctm, BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side, BlockState connectionState) {
        return ctm.isConnected(world, pos, state, this.applyConnection(pos, side), side, connectionState);
    }

    @NotNull
    public BlockPos applyConnection(BlockPos pos, Direction side) {
        return pos.m_121955_((Vec3i)this.getOffset(side));
    }

    @Override
    public Dir relativize(Direction normal) {
        throw new UnsupportedOperationException("Yell at tterrag to finish deserialization");
    }

    @Override
    @NotNull
    public BlockPos getOffset(Direction normal) {
        return this.offsets[normal.ordinal()];
    }

    @Nullable
    public LocalDirection getDirFor(Direction[] dirs) {
        if (dirs == this.dirs) {
            return this;
        }
        for (Dir dir : VALUES) {
            if (!Arrays.equals(dir.dirs, dirs)) continue;
            return dir;
        }
        return null;
    }

    private Direction rotate(Direction facing, Direction axisFacing) {
        Direction.Axis axis = axisFacing.m_122434_();
        Direction.AxisDirection axisDir = axisFacing.m_122421_();
        if (axisDir == Direction.AxisDirection.POSITIVE) {
            return DirectionHelper.rotateAround(facing, axis);
        }
        if (facing.m_122434_() != axis) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    switch (facing) {
                        case NORTH: {
                            yield Direction.UP;
                        }
                        case DOWN: {
                            yield Direction.NORTH;
                        }
                        case SOUTH: {
                            yield Direction.DOWN;
                        }
                        case UP: {
                            yield Direction.SOUTH;
                        }
                    }
                    yield facing;
                }
                case Direction.Axis.Y -> facing.m_122428_();
                case Direction.Axis.Z -> {
                    switch (facing) {
                        case EAST: {
                            yield Direction.EAST;
                        }
                        case WEST: {
                            yield Direction.WEST;
                        }
                        case UP: {
                            yield Direction.DOWN;
                        }
                        case DOWN: {
                            yield Direction.UP;
                        }
                    }
                    yield facing;
                }
            };
        }
        return facing;
    }

    @Override
    public String asJson() {
        return "{\"id\": \"" + this.name() + "\", \"directions\": " + new Gson().toJson((Object)this.dirs) + "}";
    }

    public String m_7912_() {
        return this.name();
    }

    public static LocalDirection fromDirections(List<Direction> directions) {
        return Dir.fromDirections((Direction[])directions.toArray(Direction[]::new));
    }

    public static LocalDirection fromDirections(Direction ... directions) {
        for (Dir dir : Dir.values()) {
            if (!Arrays.equals(dir.dirs, directions)) continue;
            return dir;
        }
        throw new UnsupportedOperationException("Currently invalid local direction");
    }

    static {
        VALUES = Dir.values();
        NORMAL = Direction.SOUTH;
        for (Dir dir : VALUES) {
            dir.buildCaches();
        }
    }
}

