/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.api.texture;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import team.chisel.ctm.client.util.Submap;

@ParametersAreNonnullByDefault
public interface ISubmap {
    public static final float PIXELS_PER_UNIT = 16.0f;
    public static final float UNITS_PER_PIXEL = 0.0625f;

    public float getYOffset();

    public float getXOffset();

    public float getWidth();

    public float getHeight();

    default public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
        return sprite.m_118367_((double)((this.getXOffset() + u / this.getWidth()) / 16.0f));
    }

    default public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
        return sprite.m_118393_((double)((this.getYOffset() + v / this.getHeight()) / 16.0f));
    }

    default public float[] toArray() {
        return new float[]{this.getXOffset(), this.getYOffset(), this.getXOffset() + this.getWidth(), this.getYOffset() + this.getHeight()};
    }

    default public ISubmap unitScale() {
        return new SubmapRescaled(this, 0.0625f, false);
    }

    default public ISubmap pixelScale() {
        return this;
    }

    default public ISubmap flipX() {
        return Submap.fromPixelScale(this.getWidth(), this.getHeight(), 16.0f - this.getXOffset() - this.getWidth(), this.getYOffset());
    }

    default public ISubmap flipY() {
        return Submap.fromPixelScale(this.getWidth(), this.getHeight(), this.getXOffset(), 16.0f - this.getYOffset() - this.getHeight());
    }

    public static class SubmapRescaled
    implements ISubmap {
        private final ISubmap parent;
        private final float ratio;
        private final boolean isPixelScale;

        @Override
        public float getXOffset() {
            return this.parent.getXOffset() * this.ratio;
        }

        @Override
        public float getYOffset() {
            return this.parent.getYOffset() * this.ratio;
        }

        @Override
        public float getWidth() {
            return this.parent.getWidth() * this.ratio;
        }

        @Override
        public float getHeight() {
            return this.parent.getHeight() * this.ratio;
        }

        @Override
        public ISubmap pixelScale() {
            return this.isPixelScale ? this : this.parent;
        }

        @Override
        public ISubmap unitScale() {
            return this.isPixelScale ? this.parent : this;
        }

        @Override
        public float getInterpolatedU(TextureAtlasSprite sprite, float u) {
            return this.parent.getInterpolatedU(sprite, u);
        }

        @Override
        public float getInterpolatedV(TextureAtlasSprite sprite, float v) {
            return this.parent.getInterpolatedV(sprite, v);
        }

        @Override
        public float[] toArray() {
            return this.parent.toArray();
        }

        public SubmapRescaled(ISubmap parent, float ratio, boolean isPixelScale) {
            this.parent = parent;
            this.ratio = ratio;
            this.isPixelScale = isPixelScale;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubmapRescaled)) {
                return false;
            }
            SubmapRescaled other = (SubmapRescaled)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.ratio, other.ratio) != 0) {
                return false;
            }
            if (this.isPixelScale != other.isPixelScale) {
                return false;
            }
            ISubmap this$parent = this.parent;
            ISubmap other$parent = other.parent;
            return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubmapRescaled;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.ratio);
            result = result * 59 + (this.isPixelScale ? 79 : 97);
            ISubmap $parent = this.parent;
            result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
            return result;
        }

        public String toString() {
            return "ISubmap.SubmapRescaled(" + this.parent + ", " + this.ratio + ", " + this.isPixelScale + ")";
        }
    }

    public static interface ISpriteSubmap
    extends ISubmap {
        public TextureAtlasSprite getSprite();
    }
}

