/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import io.yukkuric.botania_overpowered.helpers.WeaponHelpers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import vazkii.botania.common.entity.FallingStarEntity;
import vazkii.botania.common.entity.ThrowableCopyEntity;

@Mixin(value={FallingStarEntity.class})
public abstract class MixinStarcaller
extends ThrowableCopyEntity {
    protected MixinStarcaller(EntityType<? extends ThrowableCopyEntity> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    boolean starStrike(Entity instance, DamageSource source, float amount, Operation<Boolean> original) {
        if (BotaniaOPConfig.fallingStarSkipsNonLiving() && !(instance instanceof LivingEntity)) {
            return false;
        }
        Entity ownerRaw = this.m_19749_();
        if (!BotaniaOPConfig.fallingStarInheritsItemDamage() || !(ownerRaw instanceof LivingEntity)) {
            return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
        }
        LivingEntity attacker = (LivingEntity)ownerRaw;
        float dmg = WeaponHelpers.getAttackDamage(attacker, instance);
        if (Math.random() < 0.25) {
            dmg *= 2.0f;
        }
        return WeaponHelpers.wrapAttackTargetWithWeapon(attacker, instance, source, original, dmg);
    }
}

