/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin.flower;

import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import io.yukkuric.botania_overpowered.api.DandelifeonRules;
import io.yukkuric.botania_overpowered.helpers.ReflectionHelpers;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity;

@Mixin(value={DandelifeonBlockEntity.class})
public abstract class MixinDandelifeon
extends GeneratingFlowerBlockEntity {
    @Shadow(remap=false)
    private int radius;
    private static final String CLASSNAME_TABLE = "vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity$CellTable";
    private static ReflectionHelpers.WrappedCtor<ITable> TABLE = new ReflectionHelpers.WrappedCtor<ITable>(ITable.class, "vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity$CellTable", Integer.TYPE, DandelifeonBlockEntity.class);

    @Shadow(remap=false)
    abstract void setBlockForGeneration(BlockPos var1, int var2, int var3);

    public MixinDandelifeon(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"runSimulation"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void replaceSimulation(CallbackInfo ci) {
        ci.cancel();
        try {
            this.replaceSimulationInner();
        }
        catch (Throwable e) {
            this.radius = -1;
            MinecraftServer server = this.f_58857_.m_7654_();
            MutableComponent stackComp = Component.m_237110_((String)"bot_op.error.dandelifeon", (Object[])new Object[]{this.m_58899_(), e.toString()});
            for (ServerPlayer p : server.m_6846_().m_11314_()) {
                p.m_213846_((Component)stackComp);
            }
        }
    }

    private void replaceSimulationInner() {
        if (this.radius <= 0) {
            return;
        }
        ITable table = TABLE.get(new Object[]{this.radius, this});
        ArrayList<DandelifeonRules.LifeUpdate> changes = new ArrayList<DandelifeonRules.LifeUpdate>();
        int diameter = table.getDiameter();
        int allowDist = 1;
        boolean wipe = false;
        for (int i = 0; i < diameter; ++i) {
            boolean xInRange = Math.abs(i - this.radius) <= allowDist;
            for (int j = 0; j < diameter; ++j) {
                int oldLife = table.curStage(i, j);
                int adj = table.countScore(i, j);
                int newLife = oldLife == -1 && DandelifeonRules.CheckRuleNew(adj) ? table.nextStage(i, j) : (DandelifeonBlockEntity.Cell.isLive((int)oldLife) && DandelifeonRules.CheckRuleKeep(adj) ? oldLife + 1 : -1);
                if (xInRange && Math.abs(j - this.radius) <= allowDist && DandelifeonBlockEntity.Cell.isLive((int)newLife)) {
                    if (oldLife == 1) {
                        newLife = -1;
                    } else {
                        oldLife = newLife;
                        newLife = -2;
                        wipe = true;
                    }
                }
                if (newLife == oldLife) continue;
                changes.add(new DandelifeonRules.LifeUpdate(i, j, newLife, oldLife));
            }
        }
        if (wipe && BotaniaOPConfig.skipDandelifeonClearBoard()) {
            wipe = false;
        }
        for (DandelifeonRules.LifeUpdate change : changes) {
            BlockPos pos_ = table.getCenter().m_7918_(-this.radius + change.x(), 0, -this.radius + change.z());
            int newLife = change.newLife();
            if (wipe) {
                newLife = -1;
            }
            this.setBlockForGeneration(pos_, Math.min(newLife, 100), change.oldLife());
        }
    }

    @Mixin(targets={"vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity$CellTable"})
    public static interface ITable {
        @Accessor(value="center", remap=false)
        public BlockPos getCenter();

        @Accessor(value="diameter", remap=false)
        public int getDiameter();

        @Invoker(value="getAdjCells", remap=false)
        public int countScore(int var1, int var2);

        @Invoker(value="getSpawnCellGeneration", remap=false)
        public int nextStage(int var1, int var2);

        @Invoker(value="at", remap=false)
        public int curStage(int var1, int var2);
    }
}

