/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin.enchanter;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;

@Mixin(value={ManaEnchanterBlockEntity.class})
public abstract class MixinEnchanterBE
extends BlockEntity {
    @Shadow(remap=false)
    public ItemStack itemToEnchant;
    @Shadow(remap=false)
    @Final
    private List<EnchantmentInstance> enchants;
    @Shadow(remap=false)
    public ManaEnchanterBlockEntity.State stage;

    public MixinEnchanterBE(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Shadow(remap=false)
    protected abstract boolean hasEnchantAlready(Enchantment var1);

    @Shadow(remap=false)
    protected abstract boolean isEnchantmentValid(@Nullable Enchantment var1);

    @Shadow(remap=false)
    protected abstract void advanceStage();

    @Inject(method={"isEnchantmentValid"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    void acceptsBook(Enchantment ench, CallbackInfoReturnable<Boolean> cir) {
        if (BotaniaOPConfig.enchantBooks() && this.itemToEnchant.m_150930_(Items.f_42517_) || BotaniaOPConfig.ignoresCompatibleCheck() && ench.m_6081_(this.itemToEnchant)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"commonTick"}, at={@At(value="INVOKE", target="Ljava/util/List;clear()V")})
    private static void bookEnchantWrap(Level level, BlockPos worldPosition, BlockState state, ManaEnchanterBlockEntity self, CallbackInfo ci) {
        if (BotaniaOPConfig.enchantBooks() && self.itemToEnchant.m_150930_(Items.f_42517_)) {
            ItemStack oldItem = self.itemToEnchant;
            self.itemToEnchant = new ItemStack((ItemLike)Items.f_42690_, 1);
            self.itemToEnchant.m_41784_().m_128365_("StoredEnchantments", oldItem.m_41784_().m_128423_("Enchantments"));
        }
    }

    @Inject(method={"gatherEnchants"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/util/List;iterator()Ljava/util/Iterator;")}, cancellable=true, remap=false)
    void collectElse(CallbackInfo ci, @Local List<ItemEntity> items) {
        if (!BotaniaOPConfig.acceptsAllInsideBook()) {
            return;
        }
        boolean locatedBookThisTurn = false;
        boolean acceptsOnlyBook = !BotaniaOPConfig.treatEnchantedItemAsBook();
        for (ItemEntity entity : items) {
            Map enchants;
            ItemStack item = entity.m_32055_();
            if (acceptsOnlyBook && !item.m_150930_(Items.f_42690_) || (enchants = EnchantmentHelper.m_44831_((ItemStack)item)).isEmpty()) continue;
            boolean hasEnchantsThisBook = false;
            for (Map.Entry pair : enchants.entrySet()) {
                Enchantment enchant = (Enchantment)pair.getKey();
                if (enchant == null || this.hasEnchantAlready(enchant) || !this.isEnchantmentValid(enchant)) continue;
                this.enchants.add(new EnchantmentInstance(enchant, ((Integer)pair.getValue()).intValue()));
                hasEnchantsThisBook = true;
            }
            if (!hasEnchantsThisBook) continue;
            this.f_58857_.m_5594_(null, this.f_58858_, BotaniaSounds.ding, SoundSource.BLOCKS, 1.0f, 1.0f);
            locatedBookThisTurn = true;
            break;
        }
        if (!locatedBookThisTurn) {
            if (this.enchants.isEmpty()) {
                this.stage = ManaEnchanterBlockEntity.State.IDLE;
            } else {
                this.advanceStage();
            }
        }
        ci.cancel();
    }

    @WrapOperation(method={"gatherEnchants"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z")})
    boolean everythingIsBook(ItemStack instance, Item item, Operation<Boolean> original) {
        if (BotaniaOPConfig.treatEnchantedItemAsBook() && Objects.equals(item, Items.f_42690_)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, item});
    }

    @Inject(method={"onUsedByWand"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")}, cancellable=true)
    void skipWandInitialCheck(Player player, ItemStack wand, Direction side, CallbackInfoReturnable<Boolean> cir) {
        if (!this.f_58857_.f_46443_) {
            this.advanceStage();
            cir.setReturnValue((Object)true);
        }
    }
}

