/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.common.entity.GaiaGuardianEntity;

@Mixin(value={GaiaGuardianEntity.class})
public abstract class MixinGaiaGuardian
extends Mob {
    @Shadow(remap=false)
    private int mobSpawnTicks;
    @Shadow(remap=false)
    @Final
    private static int MOB_SPAWN_TICKS;
    @Shadow(remap=false)
    @Final
    private static int MOB_SPAWN_WAVE_TIME;

    @Shadow(remap=false)
    public abstract List<Player> getPlayersAround();

    @Shadow(remap=false)
    protected abstract void spawnMobs(List<Player> var1);

    @Shadow(remap=false)
    public abstract void setInvulTime(int var1);

    protected MixinGaiaGuardian(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    boolean isDying() {
        return this.m_21223_() / this.m_21233_() < 0.2f;
    }

    @WrapOperation(method={"hurt", "actuallyHurt", "getDamageAfterArmorAbsorb"}, at={@At(value="INVOKE", target="Ljava/lang/Math;min(FF)F")})
    float noDamageCap(float num_32, float dmg, Operation<Float> original) {
        if (BotaniaOPConfig.removesDamageCap()) {
            if (!this.isDying()) {
                return ((Float)original.call(new Object[]{Float.valueOf(this.m_21223_() - 1.0f), Float.valueOf(dmg)})).floatValue();
            }
            return dmg;
        }
        return ((Float)original.call(new Object[]{Float.valueOf(num_32), Float.valueOf(dmg)})).floatValue();
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    void decreasesHordeTime(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() || this.mobSpawnTicks >= MOB_SPAWN_TICKS) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        int ticksSkip = BotaniaOPConfig.decreasesInvulTimeByAttacking();
        if (ticksSkip <= 0) {
            return;
        }
        int oldSpawnTicks = this.mobSpawnTicks;
        this.mobSpawnTicks -= ticksSkip;
        int oldWaveCount = oldSpawnTicks / MOB_SPAWN_WAVE_TIME;
        int newWaveCount = this.mobSpawnTicks / MOB_SPAWN_WAVE_TIME;
        if (oldWaveCount <= newWaveCount) {
            return;
        }
        List<Player> players = this.getPlayersAround();
        while (oldWaveCount > newWaveCount) {
            --oldWaveCount;
            this.spawnMobs(players);
        }
    }

    @WrapOperation(method={"spawn"}, at={@At(value="INVOKE", target="Lvazkii/botania/common/helper/PlayerHelper;isTruePlayer(Lnet/minecraft/world/entity/Entity;)Z")})
    private static boolean noFakePlayerCheckStatic(Entity player, Operation<Boolean> original) {
        if (BotaniaOPConfig.allowsFakePlayer()) {
            return true;
        }
        return (Boolean)original.call(new Object[]{player});
    }

    @WrapOperation(method={"hurt", "die", "dropFromLootTable"}, at={@At(value="INVOKE", target="Lvazkii/botania/common/helper/PlayerHelper;isTruePlayer(Lnet/minecraft/world/entity/Entity;)Z")})
    private boolean noFakePlayerCheck(Entity player, Operation<Boolean> original) {
        return MixinGaiaGuardian.noFakePlayerCheckStatic(player, original);
    }
}

