/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.LexicaBotaniaItem;

public class KonamiHandler {
    private static final int[] KONAMI_CODE = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
    private static int nextLetter = 0;
    private static int konamiTime = 0;

    public static void clientTick(Minecraft client) {
        if (konamiTime > 0) {
            --konamiTime;
        }
        if (!LexicaBotaniaItem.isOpen()) {
            nextLetter = 0;
        }
    }

    public static void handleInput(int key, int action, int modifiers) {
        Minecraft mc = Minecraft.m_91087_();
        if (modifiers == 0 && action == 1 && LexicaBotaniaItem.isOpen()) {
            if (konamiTime == 0 && key == KONAMI_CODE[nextLetter]) {
                if (++nextLetter >= KONAMI_CODE.length) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)BotaniaSounds.way, (float)1.0f));
                    nextLetter = 0;
                    konamiTime = 240;
                }
            } else {
                nextLetter = 0;
            }
        }
    }

    public static void renderBook(ResourceLocation book, Screen gui, int mouseX, int mouseY, float partialTicks, GuiGraphics guiGraphics) {
        PoseStack ms = guiGraphics.m_280168_();
        if (konamiTime > 0) {
            String meme = I18n.m_118938_((String)"botania.subtitle.way", (Object[])new Object[0]);
            RenderSystem.disableDepthTest();
            ms.m_85836_();
            int fullWidth = Minecraft.m_91087_().f_91062_.m_92895_(meme);
            int left = gui.f_96543_;
            double widthPerTick = (fullWidth + gui.f_96543_) / 240;
            double currWidth = (double)left - widthPerTick * (double)(240.0f - ((float)konamiTime - partialTicks)) * 3.2;
            ms.m_85837_(currWidth, (double)(gui.f_96544_ / 2 - 10), 0.0);
            ms.m_85841_(4.0f, 4.0f, 4.0f);
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, meme, 0, 0, 0xFFFFFF);
            ms.m_85849_();
            RenderSystem.enableDepthTest();
        }
    }
}

